/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.current;

import java.util.Collection;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import me.filoghost.holographicdisplays.api.placeholder.GlobalPlaceholder;
import me.filoghost.holographicdisplays.api.placeholder.GlobalPlaceholderFactory;
import me.filoghost.holographicdisplays.api.placeholder.GlobalPlaceholderReplaceFunction;
import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholder;
import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholderFactory;
import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholderReplaceFunction;
import me.filoghost.holographicdisplays.core.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderRegistry;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class DefaultHolographicDisplaysAPI
implements HolographicDisplaysAPI {
    private final Plugin plugin;
    private final APIHologramManager apiHologramManager;
    private final PlaceholderRegistry placeholderRegistry;

    DefaultHolographicDisplaysAPI(Plugin plugin, APIHologramManager apiHologramManager, PlaceholderRegistry placeholderRegistry) {
        this.plugin = plugin;
        this.apiHologramManager = apiHologramManager;
        this.placeholderRegistry = placeholderRegistry;
    }

    @Override
    @NotNull
    public Hologram createHologram(@NotNull Location location) {
        Preconditions.notNull(location, "location");
        Preconditions.notNull(location.getWorld(), "location.getWorld()");
        return this.apiHologramManager.createHologram(ImmutablePosition.of(location), this.plugin);
    }

    @Override
    @NotNull
    public Hologram createHologram(@NotNull Position position) {
        Preconditions.notNull(position, "position");
        Preconditions.notNull(position.getWorldName(), "position.getWorldName()");
        return this.apiHologramManager.createHologram(ImmutablePosition.of(position), this.plugin);
    }

    @Override
    public void registerGlobalPlaceholder(@NotNull String identifier, int refreshIntervalTicks, @NotNull GlobalPlaceholderReplaceFunction replaceFunction) {
        this.checkIdentifier(identifier);
        Preconditions.checkArgument(refreshIntervalTicks >= 0, "refreshIntervalTicks should be positive");
        Preconditions.notNull(replaceFunction, "replaceFunction");
        this.placeholderRegistry.registerGlobalPlaceholder(this.plugin, identifier, refreshIntervalTicks, replaceFunction);
    }

    @Override
    public void registerGlobalPlaceholder(@NotNull String identifier, @NotNull GlobalPlaceholder placeholder) {
        this.checkIdentifier(identifier);
        Preconditions.notNull(placeholder, "placeholder");
        this.placeholderRegistry.registerGlobalPlaceholder(this.plugin, identifier, placeholder);
    }

    @Override
    public void registerGlobalPlaceholderFactory(@NotNull String identifier, @NotNull GlobalPlaceholderFactory placeholderFactory) {
        this.checkIdentifier(identifier);
        Preconditions.notNull(placeholderFactory, "placeholderFactory");
        this.placeholderRegistry.registerGlobalPlaceholderFactory(this.plugin, identifier, placeholderFactory);
    }

    @Override
    public void registerIndividualPlaceholder(@NotNull String identifier, int refreshIntervalTicks, @NotNull IndividualPlaceholderReplaceFunction replaceFunction) {
        this.checkIdentifier(identifier);
        Preconditions.checkArgument(refreshIntervalTicks >= 0, "refreshIntervalTicks should be positive");
        Preconditions.notNull(replaceFunction, "replaceFunction");
        this.placeholderRegistry.registerIndividualPlaceholder(this.plugin, identifier, refreshIntervalTicks, replaceFunction);
    }

    @Override
    public void registerIndividualPlaceholder(@NotNull String identifier, @NotNull IndividualPlaceholder placeholder) {
        this.checkIdentifier(identifier);
        Preconditions.notNull(placeholder, "placeholder");
        this.placeholderRegistry.registerIndividualPlaceholder(this.plugin, identifier, placeholder);
    }

    @Override
    public void registerIndividualPlaceholderFactory(@NotNull String identifier, @NotNull IndividualPlaceholderFactory placeholderFactory) {
        this.checkIdentifier(identifier);
        Preconditions.notNull(placeholderFactory, "placeholderFactory");
        this.placeholderRegistry.registerIndividualPlaceholderFactory(this.plugin, identifier, placeholderFactory);
    }

    private void checkIdentifier(String identifier) {
        Preconditions.notEmpty(identifier, "identifier");
        for (char c : identifier.toCharArray()) {
            Preconditions.checkArgument(this.isValidIdentifierCharacter(c), "identifier contains invalid character '" + c + "'");
        }
    }

    private boolean isValidIdentifierCharacter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '_';
    }

    @Override
    public boolean isRegisteredPlaceholder(@NotNull String identifier) {
        Preconditions.notNull(identifier, "identifier");
        return this.placeholderRegistry.isRegisteredIdentifier(this.plugin, identifier);
    }

    @Override
    @NotNull
    public Collection<Hologram> getHolograms() {
        return this.apiHologramManager.getHologramsByPlugin(this.plugin);
    }

    @Override
    public void deleteHolograms() {
        this.apiHologramManager.deleteHologramsIf(apiHologram -> apiHologram.getCreatorPlugin().equals((Object)this.plugin));
    }

    @Override
    @NotNull
    public Collection<String> getRegisteredPlaceholders() {
        return this.placeholderRegistry.getRegisteredPlaceholders(this.plugin);
    }

    @Override
    public void unregisterPlaceholder(@NotNull String identifier) {
        Preconditions.notNull(identifier, "identifier");
        this.placeholderRegistry.unregister(this.plugin, identifier);
    }

    @Override
    public void unregisterPlaceholders() {
        this.placeholderRegistry.unregisterAll(this.plugin);
    }
}

