/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.internal.placeholder;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.plugin.bridge.bungeecord.BungeeServerTracker;
import me.filoghost.holographicdisplays.plugin.bridge.bungeecord.ServerInfo;
import me.filoghost.holographicdisplays.plugin.config.Settings;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.AnimationPlaceholder;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.AnimationPlaceholderFactory;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.OnlinePlayersPlaceholderFactory;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.PlaceholderAPIPlaceholderFactory;
import me.filoghost.holographicdisplays.plugin.internal.placeholder.WorldPlayersPlaceholderFactory;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.collection.CollectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

public class DefaultPlaceholders {
    private static final String PINGER_NOT_ENABLED_ERROR = "[Please enable pinger]";
    private static final String NO_SERVER_SPECIFIED_ERROR = "[No server specified]";

    public static void resetAndRegister(HolographicDisplaysAPI api, AnimationPlaceholderFactory animationPlaceholderFactory, BungeeServerTracker bungeeServerTracker) {
        api.unregisterPlaceholders();
        api.registerGlobalPlaceholder("empty", Integer.MAX_VALUE, argument -> "");
        api.registerGlobalPlaceholder("rainbow", new AnimationPlaceholder(4, DefaultPlaceholders.toStringList(ChatColor.RED, ChatColor.GOLD, ChatColor.YELLOW, ChatColor.GREEN, ChatColor.AQUA, ChatColor.LIGHT_PURPLE)));
        api.registerGlobalPlaceholder("time", 10, argument -> Settings.timeFormat.format(Instant.now()));
        api.registerGlobalPlaceholderFactory("animation", animationPlaceholderFactory);
        api.registerGlobalPlaceholderFactory("world", new WorldPlayersPlaceholderFactory());
        api.registerGlobalPlaceholderFactory("online", new OnlinePlayersPlaceholderFactory(bungeeServerTracker));
        api.registerGlobalPlaceholder("max_players", 20, serverName -> {
            if (serverName == null) {
                return String.valueOf(Bukkit.getMaxPlayers());
            }
            if (!Settings.pingerEnabled) {
                return PINGER_NOT_ENABLED_ERROR;
            }
            return String.valueOf(bungeeServerTracker.getCurrentServerInfo(serverName).getMaxPlayers());
        });
        api.registerGlobalPlaceholder("status", 20, serverName -> {
            if (serverName == null) {
                return NO_SERVER_SPECIFIED_ERROR;
            }
            if (!Settings.pingerEnabled) {
                return PINGER_NOT_ENABLED_ERROR;
            }
            ServerInfo serverInfo = bungeeServerTracker.getCurrentServerInfo(serverName);
            if (serverInfo.isOnline()) {
                return Settings.pingerStatusOnline;
            }
            return Settings.pingerStatusOffline;
        });
        api.registerGlobalPlaceholder("motd", 20, serverName -> {
            if (serverName == null) {
                return NO_SERVER_SPECIFIED_ERROR;
            }
            if (!Settings.pingerEnabled) {
                return PINGER_NOT_ENABLED_ERROR;
            }
            return bungeeServerTracker.getCurrentServerInfo(serverName).getMotdLine1();
        });
        api.registerGlobalPlaceholder("motd2", 20, serverName -> {
            if (serverName == null) {
                return NO_SERVER_SPECIFIED_ERROR;
            }
            if (!Settings.pingerEnabled) {
                return PINGER_NOT_ENABLED_ERROR;
            }
            return bungeeServerTracker.getCurrentServerInfo(serverName).getMotdLine2();
        });
        api.registerIndividualPlaceholder("player", Integer.MAX_VALUE, (player, argument) -> player.getName());
        api.registerIndividualPlaceholder("displayName", 20, (player, argument) -> player.getDisplayName());
        api.registerIndividualPlaceholderFactory("papi", new PlaceholderAPIPlaceholderFactory());
    }

    private static List<String> toStringList(ChatColor ... colors) {
        return CollectionUtils.toArrayList(Arrays.asList(colors), ChatColor::toString);
    }
}

