/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.CommandHelper;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class AlignCommand
extends HologramSubCommand {
    private final InternalHologramEditor hologramEditor;

    public AlignCommand(InternalHologramEditor hologramEditor) {
        super("align", new String[0]);
        this.setMinArgs(3);
        this.setUsageArgs("<X | Y | Z | XZ> <hologramToAlign> <referenceHologram>");
        this.setDescription("Aligns a hologram to another along the specified axis.");
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        Position newPosition;
        InternalHologram referenceHologram;
        InternalHologram hologram = this.hologramEditor.getExistingHologram(args[1]);
        CommandValidate.check(hologram != (referenceHologram = this.hologramEditor.getExistingHologram(args[2])), "The holograms must not be the same.");
        Position referencePosition = referenceHologram.getPosition();
        Position oldPosition = hologram.getPosition();
        String axis = args[0];
        if (axis.equalsIgnoreCase("x")) {
            newPosition = Position.of(oldPosition.getWorldName(), referencePosition.getX(), oldPosition.getY(), oldPosition.getZ());
        } else if (axis.equalsIgnoreCase("y")) {
            newPosition = Position.of(oldPosition.getWorldName(), oldPosition.getX(), referencePosition.getY(), oldPosition.getZ());
        } else if (axis.equalsIgnoreCase("z")) {
            newPosition = Position.of(oldPosition.getWorldName(), oldPosition.getX(), oldPosition.getY(), referencePosition.getZ());
        } else if (axis.equalsIgnoreCase("xz")) {
            newPosition = Position.of(oldPosition.getWorldName(), referencePosition.getX(), oldPosition.getY(), referencePosition.getZ());
        } else {
            throw new CommandException("You must specify either X, Y, Z or XZ, " + axis + " is not a valid axis.");
        }
        hologram.setPosition(newPosition);
        this.hologramEditor.saveChanges(hologram, InternalHologramChangeEvent.ChangeType.EDIT_POSITION);
        sender.sendMessage(ColorScheme.PRIMARY + "Hologram \"" + hologram.getName() + "\" aligned to the hologram \"" + referenceHologram.getName() + "\" on the " + axis.toUpperCase() + " axis.");
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return CommandHelper.filterStartingWith(args[0], "X", "Y", "Z", "XZ");
        }
        if (args.length == 2 || args.length == 3) {
            List<String> hologramNames = this.hologramEditor.getHolograms().stream().map(InternalHologram::getName).collect(Collectors.toList());
            return CommandHelper.filterStartingWith(args[args.length - 1], hologramNames);
        }
        return Collections.emptyList();
    }
}

