/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.bridge.bungeecord;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import me.filoghost.holographicdisplays.common.DebugLogger;
import me.filoghost.holographicdisplays.plugin.bridge.bungeecord.BungeeMessenger;
import me.filoghost.holographicdisplays.plugin.bridge.bungeecord.ServerInfo;
import me.filoghost.holographicdisplays.plugin.config.ServerAddress;
import me.filoghost.holographicdisplays.plugin.config.Settings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.logging.Log;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.ping.MinecraftServerPinger;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.ping.PingParseException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.ping.PingResponse;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BungeeServerTracker {
    private static final long UNTRACK_AFTER_TIME_WITHOUT_REQUESTS = TimeUnit.MINUTES.toMillis(10L);
    private final Plugin plugin;
    private final ConcurrentMap<String, TrackedServer> trackedServers;
    private final BungeeMessenger bungeeMessenger;
    private int taskID = -1;

    public BungeeServerTracker(Plugin plugin) {
        this.plugin = plugin;
        this.trackedServers = new ConcurrentHashMap<String, TrackedServer>();
        this.bungeeMessenger = BungeeMessenger.registerNew(plugin, this::updateServerInfoFromBungee);
    }

    public void restart(int updateInterval, TimeUnit timeUnit) {
        this.trackedServers.clear();
        if (this.taskID != -1) {
            Bukkit.getScheduler().cancelTask(this.taskID);
        }
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, this::runPeriodicUpdateTask, 1L, timeUnit.toSeconds(updateInterval) * 20L);
    }

    public ServerInfo getCurrentServerInfo(@NotNull String serverName) {
        if (!Settings.pingerEnabled && !this.trackedServers.containsKey(serverName)) {
            this.bungeeMessenger.sendPlayerCountRequest(serverName);
        }
        TrackedServer trackedServer = this.trackedServers.computeIfAbsent(serverName, x$0 -> new TrackedServer((String)x$0));
        trackedServer.updateLastRequest();
        return trackedServer.serverInfo;
    }

    private void runPeriodicUpdateTask() {
        this.removeUnusedServers();
        if (Settings.pingerEnabled) {
            Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
                for (TrackedServer trackedServer : this.trackedServers.values()) {
                    this.updateServerInfoWithPinger(trackedServer);
                }
            });
        } else {
            for (String serverName : this.trackedServers.keySet()) {
                this.bungeeMessenger.sendPlayerCountRequest(serverName);
            }
        }
    }

    private void updateServerInfoWithPinger(TrackedServer trackedServer) {
        ServerAddress serverAddress = Settings.pingerServerAddresses.get(trackedServer.serverName);
        if (serverAddress != null) {
            trackedServer.serverInfo = this.pingServer(serverAddress);
        } else {
            trackedServer.serverInfo = ServerInfo.offline("[Unknown server: " + trackedServer.serverName + "]");
        }
    }

    private void updateServerInfoFromBungee(String serverName, int onlinePlayers) {
        TrackedServer trackedServer = (TrackedServer)this.trackedServers.get(serverName);
        if (trackedServer != null) {
            trackedServer.serverInfo = ServerInfo.online(onlinePlayers, 0, "");
        }
    }

    private ServerInfo pingServer(ServerAddress serverAddress) {
        try {
            PingResponse data = MinecraftServerPinger.ping(serverAddress.getAddress(), serverAddress.getPort(), Settings.pingerTimeout);
            return ServerInfo.online(data.getOnlinePlayers(), data.getMaxPlayers(), data.getMotd());
        }
        catch (PingParseException e) {
            DebugLogger.warning("Received invalid JSON response from IP \"" + serverAddress + "\": " + e.getJsonString());
            return ServerInfo.online(0, 0, "Invalid ping response (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            if (e instanceof SocketTimeoutException || e instanceof ConnectException) {
                DebugLogger.warning("Couldn't fetch data from " + serverAddress + ".", e);
            } else if (e instanceof UnknownHostException) {
                Log.warning("Couldn't fetch data from " + serverAddress + ": unknown host address.");
            } else {
                Log.warning("Couldn't fetch data from " + serverAddress + ".", e);
            }
            return ServerInfo.offline(Settings.pingerOfflineMotd);
        }
    }

    private void removeUnusedServers() {
        long now = System.currentTimeMillis();
        this.trackedServers.values().removeIf(trackedServer -> {
            if (now - ((TrackedServer)trackedServer).lastRequest > UNTRACK_AFTER_TIME_WITHOUT_REQUESTS) {
                DebugLogger.info("Untracked unused server \"" + ((TrackedServer)trackedServer).serverName + "\".");
                return true;
            }
            return false;
        });
    }

    private static class TrackedServer {
        private final String serverName;
        private volatile ServerInfo serverInfo;
        private volatile long lastRequest;

        private TrackedServer(String serverName) {
            this.serverName = serverName;
            this.serverInfo = ServerInfo.offline(Settings.pingerOfflineMotd);
        }

        private void updateLastRequest() {
            this.lastRequest = System.currentTimeMillis();
        }
    }
}

