/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.placeholder.tracking;

import java.util.HashMap;
import java.util.Objects;
import me.filoghost.holographicdisplays.core.placeholder.PlaceholderException;
import me.filoghost.holographicdisplays.core.placeholder.PlaceholderOccurrence;
import me.filoghost.holographicdisplays.core.placeholder.StandardPlaceholder;
import me.filoghost.holographicdisplays.core.placeholder.parsing.PlaceholderReplaceFunction;
import me.filoghost.holographicdisplays.core.placeholder.parsing.StringWithPlaceholders;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderExpansion;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderRegistry;
import me.filoghost.holographicdisplays.core.placeholder.tracking.ActivePlaceholder;
import me.filoghost.holographicdisplays.core.placeholder.tracking.GlobalActivePlaceholder;
import me.filoghost.holographicdisplays.core.placeholder.tracking.IndividualActivePlaceholder;
import me.filoghost.holographicdisplays.core.placeholder.tracking.NullActivePlaceholder;
import me.filoghost.holographicdisplays.core.placeholder.tracking.PlaceholderExceptionHandler;
import me.filoghost.holographicdisplays.core.tick.TickClock;
import me.filoghost.holographicdisplays.core.tick.TickExpiringMap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivePlaceholderTracker
implements PlaceholderReplaceFunction {
    private final PlaceholderRegistry registry;
    private final TickClock tickClock;
    private final PlaceholderExceptionHandler exceptionHandler;
    private final TickExpiringMap<PlaceholderOccurrence, ActivePlaceholder> activePlaceholders;
    private long lastRegistryVersion;

    public ActivePlaceholderTracker(PlaceholderRegistry registry, TickClock tickClock) {
        this.registry = registry;
        this.tickClock = tickClock;
        this.exceptionHandler = new PlaceholderExceptionHandler(tickClock);
        this.activePlaceholders = new TickExpiringMap(new HashMap(), 10L);
    }

    public void clearOutdatedEntries() {
        long currentRegistryVersion = this.registry.getVersion();
        if (this.lastRegistryVersion == currentRegistryVersion) {
            return;
        }
        this.lastRegistryVersion = currentRegistryVersion;
        this.activePlaceholders.removeEntries((placeholderOccurrence, activePlaceholder) -> {
            PlaceholderExpansion newSource;
            PlaceholderExpansion currentSource = activePlaceholder.getSource();
            return !Objects.equals(currentSource, newSource = this.registry.find((PlaceholderOccurrence)placeholderOccurrence));
        });
    }

    public void clearInactivePlaceholders() {
        this.activePlaceholders.clearUnusedEntries(this.tickClock.getCurrentTick());
    }

    @Override
    @Nullable
    public String getReplacement(@Nullable Player player, @NotNull PlaceholderOccurrence placeholderOccurrence) {
        try {
            ActivePlaceholder activePlaceholder = this.trackAndGetPlaceholder(placeholderOccurrence);
            if (player == null && activePlaceholder.isIndividual()) {
                return null;
            }
            return activePlaceholder.computeReplacement(player, this.tickClock.getCurrentTick());
        }
        catch (PlaceholderException e) {
            this.exceptionHandler.handle(e, placeholderOccurrence);
            return "[Error]";
        }
    }

    @NotNull
    private ActivePlaceholder trackAndGetPlaceholder(PlaceholderOccurrence placeholderOccurrence) throws PlaceholderException {
        ActivePlaceholder activePlaceholder = this.activePlaceholders.get(placeholderOccurrence);
        if (activePlaceholder == null) {
            activePlaceholder = this.createActivePlaceholder(placeholderOccurrence);
            this.activePlaceholders.put(placeholderOccurrence, activePlaceholder);
        }
        return activePlaceholder;
    }

    private ActivePlaceholder createActivePlaceholder(PlaceholderOccurrence placeholderOccurrence) throws PlaceholderException {
        PlaceholderExpansion placeholderExpansion = this.registry.find(placeholderOccurrence);
        StandardPlaceholder placeholder = placeholderExpansion != null ? placeholderExpansion.createPlaceholder(placeholderOccurrence.getArgument()) : null;
        if (placeholder == null) {
            return new NullActivePlaceholder(placeholderExpansion);
        }
        if (placeholder.isIndividual()) {
            return new IndividualActivePlaceholder(placeholder, placeholderOccurrence);
        }
        return new GlobalActivePlaceholder(placeholder, placeholderOccurrence);
    }

    public boolean containsIndividualPlaceholders(@NotNull StringWithPlaceholders stringWithPlaceholders) {
        return stringWithPlaceholders.anyPlaceholderMatch(occurrence -> {
            PlaceholderExpansion placeholderExpansion = this.registry.find((PlaceholderOccurrence)occurrence);
            return placeholderExpansion != null && placeholderExpansion.isIndividual();
        });
    }

    public long getRegistryVersion() {
        return this.registry.getVersion();
    }
}

