/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import me.filoghost.holographicdisplays.core.CorePreconditions;
import me.filoghost.holographicdisplays.core.base.BaseHologram;
import org.bukkit.Chunk;
import org.bukkit.World;

public abstract class BaseHologramManager<H extends BaseHologram> {
    private final List<H> holograms = new ArrayList<H>();
    private final List<H> unmodifiableHologramsView = Collections.unmodifiableList(this.holograms);

    protected void addHologram(H hologram) {
        CorePreconditions.checkMainThread();
        this.holograms.add(hologram);
    }

    public List<H> getHolograms() {
        return this.unmodifiableHologramsView;
    }

    public void deleteHologram(H hologram) {
        CorePreconditions.checkMainThread();
        ((BaseHologram)hologram).setDeleted();
        this.holograms.remove(hologram);
    }

    public void deleteHologramsIf(Predicate<H> condition) {
        CorePreconditions.checkMainThread();
        Iterator<H> iterator = this.holograms.iterator();
        while (iterator.hasNext()) {
            BaseHologram hologram = (BaseHologram)iterator.next();
            if (!condition.test(hologram)) continue;
            iterator.remove();
            hologram.setDeleted();
        }
    }

    public void deleteHolograms() {
        CorePreconditions.checkMainThread();
        Iterator<H> iterator = this.holograms.iterator();
        while (iterator.hasNext()) {
            BaseHologram hologram = (BaseHologram)iterator.next();
            iterator.remove();
            hologram.setDeleted();
        }
    }

    public void onWorldLoad(World world) {
        for (BaseHologram hologram : this.holograms) {
            hologram.onWorldLoad(world);
        }
    }

    public void onWorldUnload(World world) {
        for (BaseHologram hologram : this.holograms) {
            hologram.onWorldUnload(world);
        }
    }

    public void onChunkLoad(Chunk chunk) {
        for (BaseHologram hologram : this.holograms) {
            hologram.onChunkLoad(chunk);
        }
    }

    public void onChunkUnload(Chunk chunk) {
        for (BaseHologram hologram : this.holograms) {
            hologram.onChunkUnload(chunk);
        }
    }
}

