/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.util;

import java.nio.file.Path;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import org.jetbrains.annotations.NotNull;

public class FileUtils {
    public static boolean hasFileExtension(@NotNull Path file, String ... validExtensions) {
        return FileUtils.hasFileExtension(file.getFileName().toString(), validExtensions);
    }

    public static boolean hasFileExtension(@NotNull String fileName, String ... validExtensions) {
        int extensionBeginIndex = fileName.lastIndexOf(46);
        if (extensionBeginIndex < 0) {
            return false;
        }
        String extension = fileName.substring(extensionBeginIndex + 1);
        return Strings.containsIgnoreCase(validExtensions, extension);
    }

    public static String removeFileExtension(@NotNull String fileName) {
        int extensionBeginIndex = fileName.lastIndexOf(46);
        if (extensionBeginIndex < 0) {
            return fileName;
        }
        return fileName.substring(0, extensionBeginIndex);
    }

    public static boolean isInsideDirectory(Path file, Path directory) {
        Path canonicalFile = file.toAbsolutePath().normalize();
        Path canonicalDirectory = directory.toAbsolutePath().normalize();
        return canonicalFile.getNameCount() > canonicalDirectory.getNameCount() && canonicalFile.startsWith(canonicalDirectory);
    }
}

