/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.config;

import java.util.Objects;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigPath;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigType;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.InvalidConfigValueException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.MissingConfigValueException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigValue {
    public static final ConfigValue NULL = new ConfigValue(null, null);
    private final ConfigPath sourcePath;
    private final Object rawValue;

    public static <T> ConfigValue of(@NotNull ConfigType<T> type, @NotNull T value) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(value, "value");
        return new ConfigValue(null, type.toRawValue(value));
    }

    static ConfigValue wrapRawValue(@Nullable ConfigPath configPath, @Nullable Object rawValue) {
        return new ConfigValue(configPath, rawValue);
    }

    private ConfigValue(@Nullable ConfigPath sourcePath, @Nullable Object rawValue) {
        this.sourcePath = sourcePath;
        this.rawValue = rawValue;
    }

    @Nullable
    public <T> T as(@NotNull ConfigType<T> type) {
        return type.fromRawValueOrNull(this.rawValue);
    }

    @NotNull
    public <T> T asRequired(@NotNull ConfigType<T> type) throws MissingConfigValueException, InvalidConfigValueException {
        return type.fromRawValueRequired(this.rawValue, this.sourcePath);
    }

    @Contract(value="_, !null -> !null")
    public <T> T asOrDefault(@NotNull ConfigType<T> type, @Nullable T defaultValue) {
        return type.fromRawValueOrDefault(this.rawValue, defaultValue);
    }

    public boolean isPresentAs(@NotNull ConfigType<?> type) {
        return type.isConvertibleRawValue(this.rawValue);
    }

    Object getRawValue() {
        return this.rawValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigValue other = (ConfigValue)obj;
        return Objects.equals(this.rawValue, other.rawValue);
    }

    public int hashCode() {
        return Objects.hashCode(this.rawValue);
    }

    public String toString() {
        return Objects.toString(this.rawValue);
    }
}

