/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.CommandHelper;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeleportCommand
extends HologramSubCommand {
    private final InternalHologramEditor hologramEditor;

    public TeleportCommand(InternalHologramEditor hologramEditor) {
        super("teleport", "tp");
        this.setMinArgs(1);
        this.setUsageArgs("<hologram>");
        this.setDescription("Teleports to a hologram.");
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        Player player = CommandValidate.getPlayerSender(sender);
        InternalHologram hologram = this.hologramEditor.getExistingHologram(args[0]);
        this.hologramEditor.teleportLookingDown(player, hologram.getPosition().toLocation());
        player.sendMessage(ColorScheme.PRIMARY + "Teleported to the hologram \"" + hologram.getName() + "\".");
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length > 1) {
            return Collections.emptyList();
        }
        return CommandHelper.filterStartingWith(args[args.length - 1], this.hologramEditor.getHolograms().stream().map(InternalHologram::getName).collect(Collectors.toList()));
    }
}

