/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.filoghost.holographicdisplays.plugin.commands.HologramCommandManager;
import me.filoghost.holographicdisplays.plugin.commands.InternalHologramEditor;
import me.filoghost.holographicdisplays.plugin.commands.subs.LineEditingCommand;
import me.filoghost.holographicdisplays.plugin.commands.subs.QuickEditCommand;
import me.filoghost.holographicdisplays.plugin.event.InternalHologramChangeEvent;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologram;
import me.filoghost.holographicdisplays.plugin.internal.hologram.InternalHologramLine;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.CommandHelper;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.validation.CommandValidate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class SetLineCommand
extends LineEditingCommand
implements QuickEditCommand {
    private final HologramCommandManager commandManager;
    private final InternalHologramEditor hologramEditor;

    public SetLineCommand(HologramCommandManager commandManager, InternalHologramEditor hologramEditor) {
        super("setLine", new String[0]);
        this.setMinArgs(3);
        this.setUsageArgs("<hologram> <lineNumber> <newText>");
        this.setDescription("Changes a line of a hologram.");
        this.commandManager = commandManager;
        this.hologramEditor = hologramEditor;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) throws CommandException {
        InternalHologram hologram = this.hologramEditor.getExistingHologram(args[0]);
        String serializedLine = Strings.joinFrom(" ", args, 2);
        int lineNumber = CommandValidate.parseInteger(args[1]);
        int linesAmount = hologram.getLines().size();
        CommandValidate.check(lineNumber >= 1 && lineNumber <= linesAmount, "The line number must be between 1 and " + linesAmount + ".");
        int index = lineNumber - 1;
        InternalHologramLine line = this.hologramEditor.parseHologramLine(serializedLine);
        hologram.setLine(index, line);
        this.hologramEditor.saveChanges(hologram, InternalHologramChangeEvent.ChangeType.EDIT_LINES);
        sender.sendMessage(ColorScheme.PRIMARY + "Line " + lineNumber + " changed.");
        this.commandManager.sendQuickEditCommands(context, hologram);
    }

    @Override
    public String getActionName() {
        return "Set";
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return CommandHelper.filterStartingWith(args[args.length - 1], this.hologramEditor.getHolograms().stream().map(InternalHologram::getName).collect(Collectors.toList()));
        }
        if (args.length == 2) {
            return Collections.singletonList("1");
        }
        if (args.length == 3) {
            return Collections.singletonList("<newText>");
        }
        return Collections.emptyList();
    }
}

