/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.bridge.bungeecord;

import me.filoghost.holographicdisplays.plugin.config.Settings;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Strings;

public class ServerInfo {
    private final boolean online;
    private final int onlinePlayers;
    private final int maxPlayers;
    private final String motdLine1;
    private final String motdLine2;

    public static ServerInfo online(int onlinePlayers, int maxPlayers, String motd) {
        return new ServerInfo(true, onlinePlayers, maxPlayers, motd);
    }

    public static ServerInfo offline(String motd) {
        return new ServerInfo(false, 0, 0, motd);
    }

    private ServerInfo(boolean online, int onlinePlayers, int maxPlayers, String motd) {
        this.online = online;
        this.onlinePlayers = onlinePlayers;
        this.maxPlayers = maxPlayers;
        if (Strings.isEmpty(motd)) {
            this.motdLine1 = "";
            this.motdLine2 = "";
        } else if (motd.contains("\n")) {
            String[] lines = Strings.split(motd, "\n", 2);
            if (Settings.pingerTrimMotd) {
                lines = Strings.trim(lines);
            }
            this.motdLine1 = lines[0];
            this.motdLine2 = lines.length > 1 ? lines[1] : "";
        } else {
            if (Settings.pingerTrimMotd) {
                motd = motd.trim();
            }
            this.motdLine1 = motd;
            this.motdLine2 = "";
        }
    }

    public boolean isOnline() {
        return this.online;
    }

    public int getOnlinePlayers() {
        return this.onlinePlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public String getMotdLine1() {
        return this.motdLine1;
    }

    public String getMotdLine2() {
        return this.motdLine2;
    }
}

