/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.nms.v1_15_R1;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.UUID;
import me.filoghost.holographicdisplays.nms.v1_15_R1.DataWatcherKey;
import net.minecraft.server.v1_15_R1.Packet;
import net.minecraft.server.v1_15_R1.PacketDataSerializer;

class PacketByteBuffer {
    private static final ThreadLocal<PacketByteBuffer> LOCAL_INSTANCE = ThreadLocal.withInitial(PacketByteBuffer::new);
    private final PacketDataSerializer serializer = new PacketDataSerializer(Unpooled.buffer());

    static PacketByteBuffer get() {
        PacketByteBuffer instance = LOCAL_INSTANCE.get();
        instance.clear();
        return instance;
    }

    private PacketByteBuffer() {
    }

    void writeBoolean(boolean flag) {
        this.serializer.writeBoolean(flag);
    }

    void writeByte(int i) {
        this.serializer.writeByte(i);
    }

    void writeShort(int i) {
        this.serializer.writeShort(i);
    }

    void writeInt(int i) {
        this.serializer.writeInt(i);
    }

    void writeDouble(double d) {
        this.serializer.writeDouble(d);
    }

    void writeVarInt(int i) {
        this.serializer.d(i);
    }

    void writeVarIntArray(int i1) {
        this.writeVarInt(1);
        this.writeVarInt(i1);
    }

    void writeUUID(UUID uuid) {
        this.serializer.a(uuid);
    }

    <T> void writeDataWatcherEntry(DataWatcherKey<T> key, T value) {
        this.serializer.writeByte(key.getIndex());
        this.writeVarInt(key.getSerializerTypeID());
        key.getSerializer().a(this.serializer, value);
    }

    void writeDataWatcherEntriesEnd() {
        this.serializer.writeByte(255);
    }

    void clear() {
        this.serializer.clear();
    }

    <T extends Packet<?>> T writeDataTo(T packet) {
        try {
            packet.a(this.serializer);
            return packet;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

