/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.InvalidInstanceException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectMethod;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectUtils;

public class ValidReflectMethod<T>
implements ReflectMethod<T> {
    private final Class<T> boxedExpectedReturnClass;
    private final Method method;

    protected ValidReflectMethod(Class<T> expectedReturnClass, Method method) {
        Preconditions.notNull(expectedReturnClass, "expectedReturnClass");
        Preconditions.notNull(method, "method");
        this.boxedExpectedReturnClass = ReflectUtils.boxPrimitiveClass(expectedReturnClass);
        this.method = method;
    }

    @Override
    public T invoke(Object instance, Object ... args) throws ReflectiveOperationException {
        if (!Modifier.isStatic(this.method.getModifiers()) && instance == null) {
            throw new InvalidInstanceException("instance cannot be null when method is not static");
        }
        try {
            return this.boxedExpectedReturnClass.cast(this.method.invoke(instance, args));
        }
        catch (ReflectiveOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    @Override
    public T invokeStatic(Object ... args) throws ReflectiveOperationException {
        return this.invoke(null, args);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.method.getDeclaringClass();
    }
}

