/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.InvalidInstanceException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectField;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.reflection.ReflectUtils;
import org.jetbrains.annotations.Nullable;

public class ValidReflectField<T>
implements ReflectField<T> {
    private final Class<T> expectedClass;
    private final Class<T> boxedExpectedClass;
    private final Field field;

    protected ValidReflectField(Class<T> expectedClass, Field field) {
        Preconditions.notNull(expectedClass, "expectedClass");
        Preconditions.notNull(field, "field");
        this.expectedClass = expectedClass;
        this.boxedExpectedClass = ReflectUtils.boxPrimitiveClass(expectedClass);
        this.field = field;
    }

    @Override
    public Class<T> getExpectedClass() {
        return this.expectedClass;
    }

    @Override
    public Field getRawField() {
        return this.field;
    }

    @Override
    @Nullable
    public T getStatic() throws ReflectiveOperationException {
        return this.get(null);
    }

    @Override
    @Nullable
    public T get(Object instance) throws ReflectiveOperationException {
        this.checkInstance(instance);
        try {
            return this.boxedExpectedClass.cast(this.field.get(instance));
        }
        catch (ReflectiveOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    @Override
    public void setStatic(@Nullable T value) throws ReflectiveOperationException {
        this.set(null, value);
    }

    @Override
    public void set(Object instance, @Nullable T value) throws ReflectiveOperationException {
        this.checkInstance(instance);
        try {
            this.field.set(instance, this.boxedExpectedClass.cast(value));
        }
        catch (ReflectiveOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ReflectiveOperationException(t);
        }
    }

    private void checkInstance(Object instance) throws InvalidInstanceException {
        if (!Modifier.isStatic(this.getModifiers()) && instance == null) {
            throw new InvalidInstanceException("instance cannot be null when field is not static");
        }
    }

    @Override
    public int getModifiers() {
        return this.field.getModifiers();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.field.isAnnotationPresent(annotationClass);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        return this.field.getAnnotationsByType(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.field.getAnnotations();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }
}

