/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.lib.fcommons.config;

import java.util.LinkedHashMap;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.Preconditions;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigPath;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigSection;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigType;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.ConfigValue;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.InvalidConfigValueException;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.config.exception.MissingConfigValueException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseConfigSection {
    private LinkedHashMap<String, Object> rawValues;

    protected BaseConfigSection(LinkedHashMap<String, Object> rawValues) {
        this.setRawValues(rawValues);
    }

    protected void setRawValues(LinkedHashMap<String, Object> rawValues) {
        Preconditions.notNull(rawValues, "rawValues");
        this.rawValues = rawValues;
    }

    protected LinkedHashMap<String, Object> getRawValues() {
        return this.rawValues;
    }

    @NotNull
    public ConfigValue get(ConfigPath path) {
        return ConfigValue.wrapRawValue(path, this.getRawValue(path));
    }

    @Nullable
    public <T> T get(ConfigPath path, @NotNull ConfigType<T> type) {
        return this.getOrDefault(path, type, null);
    }

    public <T> T getOrDefault(ConfigPath path, @NotNull ConfigType<T> type, @Nullable T defaultValue) {
        return type.fromRawValueOrDefault(this.getRawValue(path), defaultValue);
    }

    @NotNull
    public <T> T getRequired(ConfigPath path, @NotNull ConfigType<T> type) throws MissingConfigValueException, InvalidConfigValueException {
        return type.fromRawValueRequired(this.getRawValue(path), path);
    }

    public void set(ConfigPath path, @NotNull ConfigValue configValue) {
        this.setRawValue(path, configValue.getRawValue());
    }

    public <T> void set(ConfigPath path, @NotNull ConfigType<T> type, @Nullable T value) {
        Object rawValue = value != null ? type.toRawValue(value) : null;
        this.setRawValue(path, rawValue);
    }

    public boolean contains(ConfigPath path) {
        return this.getRawValue(path) != null;
    }

    public void remove(ConfigPath path) {
        this.setRawValue(path, null);
    }

    @Nullable
    private Object getRawValue(ConfigPath path) {
        Preconditions.notNull(path, "path");
        BaseConfigSection targetSection = this.getParentSectionForPath(path);
        if (targetSection == null) {
            return null;
        }
        return targetSection.rawValues.get(path.getLastPart());
    }

    private void setRawValue(ConfigPath path, @Nullable Object value) {
        Preconditions.notNull(path, "path");
        if (value != null) {
            this.getOrCreateParentSectionForPath((ConfigPath)path).rawValues.put(path.getLastPart(), value);
        } else {
            BaseConfigSection section = this.getParentSectionForPath(path);
            if (section != null) {
                section.rawValues.remove(path.getLastPart());
            }
        }
    }

    @Nullable
    private BaseConfigSection getParentSectionForPath(ConfigPath path) {
        return this.getParentSectionForPath(path, false);
    }

    @NotNull
    protected BaseConfigSection getOrCreateParentSectionForPath(ConfigPath path) {
        return this.getParentSectionForPath(path, true);
    }

    @Contract(value="_, true -> !null")
    private BaseConfigSection getParentSectionForPath(ConfigPath path, boolean createIfNotExisting) {
        BaseConfigSection currentSection = this;
        for (int i = 0; i < path.getPartsLength() - 1; ++i) {
            String pathPart = path.getPart(i);
            Object rawSectionValue = currentSection.rawValues.get(pathPart);
            if (createIfNotExisting && rawSectionValue == null) {
                ConfigSection innerSection = new ConfigSection();
                currentSection.rawValues.put(pathPart, ConfigType.SECTION.toRawValue(innerSection));
                currentSection = innerSection;
                continue;
            }
            currentSection = ConfigType.SECTION.fromRawValueOrNull(rawSectionValue);
            if (currentSection != null) continue;
            return null;
        }
        return currentSection;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BaseConfigSection)) {
            return false;
        }
        BaseConfigSection other = (BaseConfigSection)obj;
        return this.rawValues.equals(other.rawValues);
    }

    public final int hashCode() {
        return this.rawValues.hashCode();
    }

    public String toString() {
        return this.rawValues.toString();
    }
}

