/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.plugin.commands.subs;

import java.util.Collections;
import java.util.List;
import me.filoghost.holographicdisplays.plugin.HolographicDisplays;
import me.filoghost.holographicdisplays.plugin.commands.HologramSubCommand;
import me.filoghost.holographicdisplays.plugin.event.HolographicDisplaysReloadEvent;
import me.filoghost.holographicdisplays.plugin.format.ColorScheme;
import me.filoghost.holographicdisplays.plugin.lib.fcommons.command.sub.SubCommandContext;
import me.filoghost.holographicdisplays.plugin.log.PrintableErrorCollector;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Event;

public class ReloadCommand
extends HologramSubCommand {
    private final HolographicDisplays holographicDisplays;

    public ReloadCommand(HolographicDisplays holographicDisplays) {
        super("reload", new String[0]);
        this.setDescription("Reloads the plugin, including the configuration and the holograms.");
        this.holographicDisplays = holographicDisplays;
    }

    @Override
    public void execute(CommandSender sender, String[] args, SubCommandContext context) {
        PrintableErrorCollector errorCollector = new PrintableErrorCollector();
        this.holographicDisplays.load(errorCollector);
        if (!errorCollector.hasErrors()) {
            sender.sendMessage(ColorScheme.PRIMARY + "Plugin reloaded successfully.");
        } else {
            errorCollector.logToConsole();
            sender.sendMessage(ColorScheme.ERROR + "Plugin reloaded with " + errorCollector.getErrorsCount() + " error(s).");
            if (!(sender instanceof ConsoleCommandSender)) {
                sender.sendMessage(ColorScheme.ERROR + "Check the console for the details.");
            }
        }
        Bukkit.getPluginManager().callEvent((Event)new HolographicDisplaysReloadEvent());
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }
}

