/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.listener;

import me.filoghost.holographicdisplays.core.listener.LineClickListener;
import me.filoghost.holographicdisplays.core.tick.TickingTask;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class PlayerListener
implements Listener {
    private final NMSManager nmsManager;
    private final LineClickListener lineClickListener;
    private final TickingTask tickingTask;

    public PlayerListener(NMSManager nmsManager, LineClickListener lineClickListener, TickingTask tickingTask) {
        this.nmsManager = nmsManager;
        this.lineClickListener = lineClickListener;
        this.tickingTask = tickingTask;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.tickingTask.onPlayerJoin(player);
        this.nmsManager.injectPacketListener(player, this.lineClickListener);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.tickingTask.onPlayerQuit(player);
        this.nmsManager.uninjectPacketListener(player);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        this.tickingTask.onPlayerRespawn(player);
    }
}

