/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.nms.v1_21_R5;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.filoghost.fcommons.Strings;
import me.filoghost.holographicdisplays.nms.common.EntityID;
import me.filoghost.holographicdisplays.nms.v1_21_R5.DataWatcherKey;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.inventory.ItemStack;

abstract class DataWatcherPacketBuilder<T> {
    private static final int MAX_CUSTOM_NAME_LENGTH = 5000;
    protected final EntityID entityId;
    protected List<DataWatcher.c<?>> watchers = new ArrayList();

    public DataWatcherPacketBuilder(EntityID entityId) {
        this.entityId = entityId;
    }

    DataWatcherPacketBuilder<T> setInvisible() {
        this.watchers.add(new DataWatcher.c(DataWatcherKey.ENTITY_STATUS.getIndex(), DataWatcherKey.ENTITY_STATUS.getSerializer(), (Object)32));
        return this;
    }

    DataWatcherPacketBuilder<T> setArmorStandMarker() {
        this.setInvisible();
        this.watchers.add(new DataWatcher.c(DataWatcherKey.ARMOR_STAND_STATUS.getIndex(), DataWatcherKey.ARMOR_STAND_STATUS.getSerializer(), (Object)27));
        return this;
    }

    DataWatcherPacketBuilder<T> setCustomName(String customName) {
        this.watchers.add(new DataWatcher.c(DataWatcherKey.CUSTOM_NAME.getIndex(), DataWatcherKey.CUSTOM_NAME.getSerializer(), this.getCustomNameDataWatcherValue(customName)));
        this.watchers.add(new DataWatcher.c(DataWatcherKey.CUSTOM_NAME_VISIBILITY.getIndex(), DataWatcherKey.CUSTOM_NAME_VISIBILITY.getSerializer(), (Object)(!Strings.isEmpty((String)customName) ? 1 : 0)));
        return this;
    }

    private Optional<IChatBaseComponent> getCustomNameDataWatcherValue(String customName) {
        if (!Strings.isEmpty((String)(customName = Strings.truncate((String)customName, (int)5000)))) {
            return Optional.of(CraftChatMessage.fromString((String)customName, (boolean)false, (boolean)true)[0]);
        }
        return Optional.empty();
    }

    DataWatcherPacketBuilder<T> setItemStack(ItemStack itemStack) {
        this.watchers.add(new DataWatcher.c(DataWatcherKey.ITEM_STACK.getIndex(), DataWatcherKey.ITEM_STACK.getSerializer(), (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)));
        return this;
    }

    DataWatcherPacketBuilder<T> setSlimeSmall() {
        this.watchers.add(new DataWatcher.c(DataWatcherKey.SLIME_SIZE.getIndex(), DataWatcherKey.SLIME_SIZE.getSerializer(), (Object)0));
        return this;
    }

    T build() {
        return this.createPacket();
    }

    abstract T createPacket();
}

