/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.nms.v1_14_R1;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.filoghost.fcommons.logging.ErrorCollector;
import me.filoghost.fcommons.logging.Log;
import me.filoghost.fcommons.reflection.ReflectField;
import me.filoghost.holographicdisplays.nms.common.EntityID;
import me.filoghost.holographicdisplays.nms.common.FallbackEntityIDGenerator;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.common.PacketListener;
import me.filoghost.holographicdisplays.nms.common.entity.ClickableNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.common.entity.ItemNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.common.entity.TextNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.v1_14_R1.DataWatcherKey;
import me.filoghost.holographicdisplays.nms.v1_14_R1.InboundPacketHandler;
import me.filoghost.holographicdisplays.nms.v1_14_R1.VersionClickableNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.v1_14_R1.VersionItemNMSPacketEntity;
import me.filoghost.holographicdisplays.nms.v1_14_R1.VersionTextNMSPacketEntity;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.NetworkManager;
import net.minecraft.server.v1_14_R1.PlayerConnection;
import org.bukkit.craftbukkit.v1_14_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class VersionNMSManager
implements NMSManager {
    private static final ReflectField<AtomicInteger> ENTITY_ID_COUNTER_FIELD = ReflectField.lookup(AtomicInteger.class, Entity.class, (String)"entityCount");
    private final Supplier<Integer> entityIDGenerator;

    public VersionNMSManager(ErrorCollector errorCollector) {
        this.entityIDGenerator = this.getEntityIDGenerator(errorCollector);
        DataWatcherKey.ENTITY_STATUS.getIndex();
    }

    private Supplier<Integer> getEntityIDGenerator(ErrorCollector errorCollector) {
        try {
            AtomicInteger nmsEntityIDCounter = (AtomicInteger)ENTITY_ID_COUNTER_FIELD.getStatic();
            return nmsEntityIDCounter::incrementAndGet;
        }
        catch (ReflectiveOperationException e) {
            errorCollector.add((Throwable)e, new String[]{"Could not get the NMS entity ID generator. There is a small chance of entity ID conflicts, causing client-side issues on single entities."});
            return new FallbackEntityIDGenerator();
        }
    }

    private EntityID newEntityID() {
        return new EntityID(this.entityIDGenerator);
    }

    public TextNMSPacketEntity newTextPacketEntity() {
        return new VersionTextNMSPacketEntity(this.newEntityID());
    }

    public ItemNMSPacketEntity newItemPacketEntity() {
        return new VersionItemNMSPacketEntity(this.newEntityID(), this.newEntityID());
    }

    public ClickableNMSPacketEntity newClickablePacketEntity() {
        return new VersionClickableNMSPacketEntity(this.newEntityID());
    }

    public void injectPacketListener(Player player, PacketListener packetListener) {
        this.modifyPipeline(player, pipeline -> {
            ChannelHandler currentListener = pipeline.get("holographic_displays_listener");
            if (currentListener != null) {
                pipeline.remove("holographic_displays_listener");
            }
            pipeline.addBefore("packet_handler", "holographic_displays_listener", (ChannelHandler)new InboundPacketHandler(player, packetListener));
        });
    }

    public void uninjectPacketListener(Player player) {
        this.modifyPipeline(player, pipeline -> {
            ChannelHandler currentListener = pipeline.get("holographic_displays_listener");
            if (currentListener != null) {
                pipeline.remove("holographic_displays_listener");
            }
        });
    }

    private void modifyPipeline(Player player, Consumer<ChannelPipeline> pipelineModifierTask) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        NetworkManager networkManager = playerConnection.a();
        Channel channel = networkManager.channel;
        if (channel == null) {
            return;
        }
        EventLoop eventLoop = channel.eventLoop();
        Runnable safeModifierTask = () -> {
            if (!player.isOnline()) {
                return;
            }
            try {
                pipelineModifierTask.accept(channel.pipeline());
            }
            catch (Exception e) {
                Log.warning((String)"Unexpected error while modifying the channel pipeline.", (Throwable)e);
            }
        };
        if (eventLoop.inEventLoop()) {
            safeModifierTask.run();
        } else {
            eventLoop.execute(safeModifierTask);
        }
    }
}

