/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.example.powerups;

import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import me.filoghost.holographicdisplays.api.hologram.line.ItemHologramLine;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PowerUps
extends JavaPlugin
implements Listener {
    private HolographicDisplaysAPI holographicDisplaysAPI;

    public void onEnable() {
        if (!Bukkit.getPluginManager().isPluginEnabled("HolographicDisplays")) {
            this.getLogger().severe("*** HolographicDisplays is not installed or not enabled. ***");
            this.getLogger().severe("*** This plugin will be disabled. ***");
            this.setEnabled(false);
            return;
        }
        this.holographicDisplaysAPI = HolographicDisplaysAPI.get((Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntityType() == EntityType.ZOMBIE) {
            event.getDrops().clear();
            event.setDroppedExp(0);
            Hologram hologram = this.holographicDisplaysAPI.createHologram(event.getEntity().getLocation().add(0.0, 0.9, 0.0));
            hologram.getLines().appendText(ChatColor.AQUA + "" + ChatColor.BOLD + "Speed PowerUp");
            ItemHologramLine itemLine = hologram.getLines().appendItem(new ItemStack(Material.SUGAR));
            itemLine.setPickupListener(pickupEvent -> {
                pickupEvent.getPlayer().playEffect(hologram.getPosition().toLocation(), Effect.MOBSPAWNER_FLAMES, null);
                pickupEvent.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 600, 1), true);
                hologram.delete();
            });
        }
    }
}

