/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.example.deathholograms;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DeathHolograms
extends JavaPlugin
implements Listener {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("H:mm");
    private HolographicDisplaysAPI holographicDisplaysAPI;

    public void onEnable() {
        if (!Bukkit.getPluginManager().isPluginEnabled("HolographicDisplays")) {
            this.getLogger().severe("*** HolographicDisplays is not installed or not enabled. ***");
            this.getLogger().severe("*** This plugin will be disabled. ***");
            this.setEnabled(false);
            return;
        }
        this.holographicDisplaysAPI = HolographicDisplaysAPI.get((Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Hologram hologram = this.holographicDisplaysAPI.createHologram(event.getEntity().getEyeLocation());
        hologram.getLines().appendText(ChatColor.RED + "Player " + ChatColor.GOLD + event.getEntity().getName() + ChatColor.RED + " died here!");
        hologram.getLines().appendText(ChatColor.GRAY + "Time of death: " + TIME_FORMATTER.format(Instant.now()));
    }
}

