/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tracking;

import java.util.List;
import java.util.Objects;
import me.filoghost.holographicdisplays.common.PositionCoordinates;
import me.filoghost.holographicdisplays.core.base.BaseItemHologramLine;
import me.filoghost.holographicdisplays.core.listener.LineClickListener;
import me.filoghost.holographicdisplays.core.tick.CachedPlayer;
import me.filoghost.holographicdisplays.core.tracking.ClickableLineTracker;
import me.filoghost.holographicdisplays.core.tracking.CollisionHelper;
import me.filoghost.holographicdisplays.core.tracking.PacketSenderExecutor;
import me.filoghost.holographicdisplays.core.tracking.Viewer;
import me.filoghost.holographicdisplays.core.tracking.Viewers;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.common.entity.ItemNMSPacketEntity;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public class ItemLineTracker
extends ClickableLineTracker<Viewer> {
    private final BaseItemHologramLine line;
    private final ItemNMSPacketEntity itemEntity;
    private ItemStack itemStack;
    private boolean itemStackChanged;
    private boolean spawnItemEntity;
    private boolean spawnItemEntityChanged;

    public ItemLineTracker(BaseItemHologramLine line, NMSManager nmsManager, LineClickListener lineClickListener) {
        super(line, nmsManager, lineClickListener);
        this.line = line;
        this.itemEntity = nmsManager.newItemPacketEntity();
    }

    @Override
    public BaseItemHologramLine getLine() {
        return this.line;
    }

    @Override
    @MustBeInvokedByOverriders
    protected void update(List<CachedPlayer> onlinePlayers, List<CachedPlayer> movedPlayers, int maxViewRange) {
        super.update(onlinePlayers, movedPlayers, maxViewRange);
        if (this.spawnItemEntity && this.hasViewers() && this.line.hasPickupCallback()) {
            for (Viewer viewer : this.getViewers()) {
                this.invokePickupIfNecessary(viewer);
            }
        }
    }

    private void invokePickupIfNecessary(Viewer viewer) {
        Location location = viewer.getLocation();
        Player player = viewer.getBukkitPlayer();
        if (location != null && CollisionHelper.isInPickupRange(location, this.positionCoordinates) && this.canInteract(player)) {
            this.line.onPickup(player);
        }
    }

    @Override
    protected boolean updatePlaceholders() {
        return false;
    }

    @Override
    protected Viewer createViewer(CachedPlayer cachedPlayer) {
        return new Viewer(cachedPlayer);
    }

    @Override
    @MustBeInvokedByOverriders
    protected void detectChanges() {
        boolean spawnItemEntity;
        super.detectChanges();
        ItemStack itemStack = this.line.getItemStack();
        if (!Objects.equals(this.itemStack, itemStack)) {
            this.itemStack = itemStack;
            this.itemStackChanged = true;
        }
        boolean bl = spawnItemEntity = itemStack != null;
        if (this.spawnItemEntity != spawnItemEntity) {
            this.spawnItemEntity = spawnItemEntity;
            this.spawnItemEntityChanged = true;
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void clearDetectedChanges() {
        super.clearDetectedChanges();
        this.itemStackChanged = false;
        this.spawnItemEntityChanged = false;
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendSpawnPackets(Viewers<Viewer> viewers) {
        super.sendSpawnPackets(viewers);
        if (this.spawnItemEntity) {
            PositionCoordinates positionCoordinates = this.positionCoordinates;
            ItemStack itemStack = this.itemStack;
            PacketSenderExecutor.execute(() -> viewers.sendPackets(this.itemEntity.newSpawnPackets(positionCoordinates, itemStack)));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendDestroyPackets(Viewers<Viewer> viewers) {
        super.sendDestroyPackets(viewers);
        if (this.spawnItemEntity) {
            PacketSenderExecutor.execute(() -> viewers.sendPackets(this.itemEntity.newDestroyPackets()));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendChangesPackets(Viewers<Viewer> viewers) {
        super.sendChangesPackets(viewers);
        if (this.spawnItemEntityChanged) {
            if (this.spawnItemEntity) {
                PositionCoordinates positionCoordinates = this.positionCoordinates;
                ItemStack itemStack = this.itemStack;
                PacketSenderExecutor.execute(() -> viewers.sendPackets(this.itemEntity.newSpawnPackets(positionCoordinates, itemStack)));
            } else {
                PacketSenderExecutor.execute(() -> viewers.sendPackets(this.itemEntity.newDestroyPackets()));
            }
        } else if (this.itemStackChanged) {
            ItemStack itemStack = this.itemStack;
            PacketSenderExecutor.execute(() -> viewers.sendPackets(this.itemEntity.newChangePackets(itemStack)));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendPositionChangePackets(Viewers<Viewer> viewers) {
        super.sendPositionChangePackets(viewers);
        if (this.spawnItemEntity) {
            PositionCoordinates positionCoordinates = this.positionCoordinates;
            PacketSenderExecutor.execute(() -> viewers.sendPackets(this.itemEntity.newTeleportPackets(positionCoordinates)));
        }
    }

    @Override
    protected double getViewRange() {
        return 16.0;
    }
}

