/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tracking;

import java.util.Collection;
import java.util.Objects;
import me.filoghost.fcommons.Preconditions;
import me.filoghost.holographicdisplays.core.placeholder.parsing.StringWithPlaceholders;
import me.filoghost.holographicdisplays.core.placeholder.tracking.ActivePlaceholderTracker;
import me.filoghost.holographicdisplays.core.tracking.TextLineViewer;
import me.filoghost.holographicdisplays.core.tracking.Viewer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DisplayText {
    private final ActivePlaceholderTracker placeholderTracker;
    @Nullable
    private StringWithPlaceholders unreplacedText;
    private boolean allowPlaceholders;
    @Nullable
    private String globalText;
    @Nullable
    private Boolean containsIndividualPlaceholders;
    private long lastPlaceholderRegistryVersion;

    DisplayText(ActivePlaceholderTracker placeholderTracker) {
        this.placeholderTracker = placeholderTracker;
    }

    boolean containsIndividualPlaceholders() {
        if (!this.allowPlaceholders || this.unreplacedText == null) {
            return false;
        }
        long currentPlaceholderRegistryVersion = this.placeholderTracker.getRegistryVersion();
        if (this.containsIndividualPlaceholders == null || this.lastPlaceholderRegistryVersion != currentPlaceholderRegistryVersion) {
            this.containsIndividualPlaceholders = this.placeholderTracker.containsIndividualPlaceholders(this.unreplacedText);
            this.lastPlaceholderRegistryVersion = currentPlaceholderRegistryVersion;
        }
        return this.containsIndividualPlaceholders;
    }

    void setUnreplacedText(@Nullable String text) {
        this.unreplacedText = text != null ? StringWithPlaceholders.of(text) : null;
        this.globalText = null;
        this.containsIndividualPlaceholders = null;
    }

    @Nullable
    String getUnreplacedText() {
        return this.unreplacedText != null ? this.unreplacedText.getString() : null;
    }

    public boolean isAllowPlaceholders() {
        return this.allowPlaceholders;
    }

    public void setAllowPlaceholders(boolean allowPlaceholders) {
        this.allowPlaceholders = allowPlaceholders;
    }

    @Nullable
    String getGlobalText() {
        return this.globalText;
    }

    public boolean updateReplacements(Collection<TextLineViewer> viewers) {
        boolean changed = false;
        if (this.containsIndividualPlaceholders()) {
            this.globalText = null;
            for (TextLineViewer viewer : viewers) {
                if (!viewer.updateIndividualText()) continue;
                changed = true;
            }
        } else {
            String globalText = this.computeGlobalText();
            if (!Objects.equals(this.globalText, globalText)) {
                this.globalText = globalText;
                changed = true;
            }
        }
        return changed;
    }

    @Nullable
    private String computeGlobalText() {
        if (this.allowPlaceholders && this.unreplacedText != null && this.unreplacedText.containsPlaceholders()) {
            return this.unreplacedText.replacePlaceholders(null, this.placeholderTracker);
        }
        return this.unreplacedText != null ? this.unreplacedText.getString() : null;
    }

    @NotNull
    public String computeIndividualText(Viewer viewer) {
        Preconditions.notNull((Object)this.unreplacedText, (String)"unreplacedText");
        return this.unreplacedText.replacePlaceholders(viewer.getBukkitPlayer(), this.placeholderTracker);
    }
}

