/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.placeholder.registry;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import me.filoghost.fcommons.collection.CaseInsensitiveString;
import me.filoghost.fcommons.collection.CollectionUtils;
import me.filoghost.fcommons.logging.Log;
import me.filoghost.holographicdisplays.api.placeholder.GlobalPlaceholder;
import me.filoghost.holographicdisplays.api.placeholder.GlobalPlaceholderFactory;
import me.filoghost.holographicdisplays.api.placeholder.GlobalPlaceholderReplaceFunction;
import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholder;
import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholderFactory;
import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholderReplaceFunction;
import me.filoghost.holographicdisplays.core.placeholder.PlaceholderIdentifier;
import me.filoghost.holographicdisplays.core.placeholder.PlaceholderOccurrence;
import me.filoghost.holographicdisplays.core.placeholder.PluginName;
import me.filoghost.holographicdisplays.core.placeholder.registry.GlobalPlaceholderExpansion;
import me.filoghost.holographicdisplays.core.placeholder.registry.IndividualPlaceholderExpansion;
import me.filoghost.holographicdisplays.core.placeholder.registry.LegacyGlobalPlaceholderExpansion;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderExpansion;
import me.filoghost.holographicdisplays.core.placeholder.registry.SimpleGlobalPlaceholder;
import me.filoghost.holographicdisplays.core.placeholder.registry.SimpleIndividualPlaceholder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class PlaceholderRegistry {
    private final Table<PlaceholderIdentifier, PluginName, PlaceholderExpansion> placeholderExpansions = HashBasedTable.create();
    private final Table<CaseInsensitiveString, PluginName, LegacyGlobalPlaceholderExpansion> legacyPlaceholderExpansions = HashBasedTable.create();
    private final AtomicLong version = new AtomicLong();

    public long getVersion() {
        return this.version.get();
    }

    public void registerIndividualPlaceholder(Plugin plugin, String identifier, int refreshIntervalTicks, IndividualPlaceholderReplaceFunction replaceFunction) {
        this.registerIndividualPlaceholder(plugin, identifier, new SimpleIndividualPlaceholder(refreshIntervalTicks, replaceFunction));
    }

    public void registerIndividualPlaceholder(Plugin plugin, String identifier, IndividualPlaceholder placeholder) {
        this.registerIndividualPlaceholderFactory(plugin, identifier, argument -> placeholder);
    }

    public void registerIndividualPlaceholderFactory(Plugin plugin, String identifier, IndividualPlaceholderFactory factory) {
        IndividualPlaceholderExpansion expansion = new IndividualPlaceholderExpansion(plugin, identifier, factory);
        this.registerExpansion(expansion);
    }

    public void registerGlobalPlaceholder(Plugin plugin, String identifier, int refreshIntervalTicks, GlobalPlaceholderReplaceFunction replaceFunction) {
        this.registerGlobalPlaceholder(plugin, identifier, new SimpleGlobalPlaceholder(refreshIntervalTicks, replaceFunction));
    }

    public void registerGlobalPlaceholder(Plugin plugin, String identifier, GlobalPlaceholder placeholder) {
        this.registerGlobalPlaceholderFactory(plugin, identifier, argument -> placeholder);
    }

    public void registerGlobalPlaceholderFactory(Plugin plugin, String identifier, GlobalPlaceholderFactory factory) {
        GlobalPlaceholderExpansion expansion = new GlobalPlaceholderExpansion(plugin, identifier, factory);
        this.registerExpansion(expansion);
    }

    private void registerExpansion(PlaceholderExpansion expansion) {
        this.placeholderExpansions.put((Object)expansion.getIdentifier(), (Object)expansion.getPluginName(), (Object)expansion);
        this.version.incrementAndGet();
    }

    public void unregisterAll(Plugin plugin) {
        this.placeholderExpansions.column((Object)new PluginName(plugin)).clear();
        this.version.incrementAndGet();
    }

    public void unregister(Plugin plugin, String identifier) {
        this.placeholderExpansions.remove((Object)new PlaceholderIdentifier(identifier), (Object)new PluginName(plugin));
        this.version.incrementAndGet();
    }

    @Nullable
    public PlaceholderExpansion find(PlaceholderOccurrence textOccurrence) {
        PluginName pluginName = textOccurrence.getPluginName();
        PlaceholderIdentifier identifier = textOccurrence.getIdentifier();
        PlaceholderExpansion result = pluginName != null ? (PlaceholderExpansion)this.placeholderExpansions.get((Object)identifier, (Object)pluginName) : (PlaceholderExpansion)Iterables.getFirst(this.placeholderExpansions.row((Object)identifier).values(), null);
        if (result == null && !this.legacyPlaceholderExpansions.isEmpty()) {
            result = (PlaceholderExpansion)Iterables.getFirst(this.legacyPlaceholderExpansions.row((Object)textOccurrence.getUnparsedContent()).values(), null);
        }
        return result;
    }

    public Collection<String> getRegisteredPlaceholders(Plugin plugin) {
        PluginName pluginName = new PluginName(plugin);
        Collection pluginExpansions = this.placeholderExpansions.column((Object)pluginName).values();
        return CollectionUtils.toImmutableSet(pluginExpansions, expansion -> expansion.getIdentifier().toString());
    }

    public boolean isRegisteredIdentifier(Plugin plugin, String identifier) {
        return this.placeholderExpansions.contains((Object)new PlaceholderIdentifier(identifier), (Object)new PluginName(plugin));
    }

    public void registerLegacyPlaceholder(Plugin plugin, String legacyTextPlaceholder, int refreshIntervalTicks, GlobalPlaceholderReplaceFunction replaceFunction) {
        String newIdentifier = this.convertLegacyPlaceholderToNewIdentifier(legacyTextPlaceholder);
        if (newIdentifier.equals(legacyTextPlaceholder)) {
            Log.warning((String)("The plugin " + plugin.getName() + " registered the placeholder " + legacyTextPlaceholder + " with the old v2 API, but is not compliant with the new format. In order to display it, you must use {" + newIdentifier + "} instead."));
        }
        SimpleGlobalPlaceholder placeholder = new SimpleGlobalPlaceholder(refreshIntervalTicks, replaceFunction);
        GlobalPlaceholderFactory placeholderFactory = argument -> placeholder;
        LegacyGlobalPlaceholderExpansion expansion = new LegacyGlobalPlaceholderExpansion(plugin, newIdentifier, placeholderFactory, legacyTextPlaceholder);
        this.legacyPlaceholderExpansions.put((Object)new CaseInsensitiveString(newIdentifier), (Object)new PluginName(plugin), (Object)expansion);
        this.version.incrementAndGet();
    }

    public void unregisterLegacyPlaceholder(Plugin plugin, String legacyTextPlaceholder) {
        String newIdentifier = this.convertLegacyPlaceholderToNewIdentifier(legacyTextPlaceholder);
        this.legacyPlaceholderExpansions.remove((Object)new CaseInsensitiveString(newIdentifier), (Object)new PluginName(plugin));
        this.version.incrementAndGet();
    }

    public void unregisterAllLegacyPlaceholders(Plugin plugin) {
        this.legacyPlaceholderExpansions.column((Object)new PluginName(plugin)).clear();
        this.version.incrementAndGet();
    }

    public boolean isRegisteredLegacyPlaceholder(Plugin plugin, String legacyTextPlaceholder) {
        String newIdentifier = this.convertLegacyPlaceholderToNewIdentifier(legacyTextPlaceholder);
        return this.legacyPlaceholderExpansions.contains((Object)new CaseInsensitiveString(newIdentifier), (Object)new PluginName(plugin));
    }

    public Collection<LegacyGlobalPlaceholderExpansion> getRegisteredLegacyPlaceholders(Plugin plugin) {
        return this.legacyPlaceholderExpansions.column((Object)new PluginName(plugin)).values();
    }

    private String convertLegacyPlaceholderToNewIdentifier(String legacyTextPlaceholder) {
        if (legacyTextPlaceholder.startsWith("{") && legacyTextPlaceholder.endsWith("}")) {
            return legacyTextPlaceholder.substring(1, legacyTextPlaceholder.length() - 1);
        }
        return legacyTextPlaceholder;
    }
}

