/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.filoghost.holographicdisplays.core.CoreGlobalConfig;
import me.filoghost.holographicdisplays.core.CorePreconditions;
import me.filoghost.holographicdisplays.core.base.BaseHologram;
import me.filoghost.holographicdisplays.core.base.EditableHologramLine;
import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import me.filoghost.holographicdisplays.core.tracking.LineTrackerManager;
import org.jetbrains.annotations.NotNull;

public class BaseHologramLines<T extends EditableHologramLine>
implements Iterable<T> {
    private final BaseHologram hologram;
    private final LineTrackerManager lineTrackerManager;
    private final List<T> lines;
    private final List<T> unmodifiableLinesView;

    public BaseHologramLines(BaseHologram hologram, LineTrackerManager lineTrackerManager) {
        this.hologram = hologram;
        this.lineTrackerManager = lineTrackerManager;
        this.lines = new ArrayList<T>();
        this.unmodifiableLinesView = Collections.unmodifiableList(this.lines);
    }

    @Override
    public Iterator<T> iterator() {
        CorePreconditions.checkMainThread();
        return this.unmodifiableLinesView.iterator();
    }

    public int size() {
        CorePreconditions.checkMainThread();
        return this.lines.size();
    }

    @NotNull
    public T get(int index) {
        CorePreconditions.checkMainThread();
        return (T)((EditableHologramLine)this.lines.get(index));
    }

    public void add(T line) {
        CorePreconditions.checkMainThread();
        this.checkNotDeleted();
        this.lines.add(line);
        this.lineTrackerManager.startTracking(line);
        this.updatePositions();
    }

    public void insert(int beforeIndex, T line) {
        CorePreconditions.checkMainThread();
        this.checkNotDeleted();
        this.lines.add(beforeIndex, line);
        this.lineTrackerManager.startTracking(line);
        this.updatePositions();
    }

    public void remove(int index) {
        CorePreconditions.checkMainThread();
        this.checkNotDeleted();
        ((EditableHologramLine)this.lines.remove(index)).setDeleted();
        this.updatePositions();
    }

    public boolean remove(T line) {
        CorePreconditions.checkMainThread();
        this.checkNotDeleted();
        boolean removed = this.lines.remove(line);
        if (removed) {
            line.setDeleted();
            this.updatePositions();
        }
        return removed;
    }

    public void clear() {
        CorePreconditions.checkMainThread();
        this.checkNotDeleted();
        Iterator<T> iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            EditableHologramLine line = (EditableHologramLine)iterator.next();
            iterator.remove();
            line.setDeleted();
        }
    }

    public void updatePositions() {
        ImmutablePosition hologramPosition = this.hologram.getPosition();
        double currentLineY = hologramPosition.getY();
        for (int i = 0; i < this.lines.size(); ++i) {
            EditableHologramLine line = (EditableHologramLine)this.lines.get(i);
            currentLineY -= line.getHeight();
            if (i > 0) {
                currentLineY -= CoreGlobalConfig.spaceBetweenLines;
            }
            line.setCoordinates(hologramPosition.getX(), currentLineY, hologramPosition.getZ());
        }
    }

    public double getHeight() {
        CorePreconditions.checkMainThread();
        if (this.lines.isEmpty()) {
            return 0.0;
        }
        double height = 0.0;
        for (EditableHologramLine line : this.lines) {
            height += line.getHeight();
        }
        return height += CoreGlobalConfig.spaceBetweenLines * (double)(this.lines.size() - 1);
    }

    public void setDeleted() {
        for (EditableHologramLine line : this.lines) {
            line.setDeleted();
        }
    }

    protected void checkNotDeleted() {
        this.hologram.checkNotDeleted();
    }

    public String toString() {
        return this.lines.toString();
    }
}

