/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.current;

import me.filoghost.fcommons.Preconditions;
import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import me.filoghost.holographicdisplays.api.hologram.PlaceholderSetting;
import me.filoghost.holographicdisplays.core.CorePreconditions;
import me.filoghost.holographicdisplays.core.api.current.APIHologramLine;
import me.filoghost.holographicdisplays.core.api.current.APIHologramLines;
import me.filoghost.holographicdisplays.core.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.core.base.BaseHologram;
import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import me.filoghost.holographicdisplays.core.tracking.LineTrackerManager;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class APIHologram
extends BaseHologram
implements Hologram {
    private final APIHologramLines lines;
    private final Plugin plugin;
    private final APIHologramManager hologramManager;
    @NotNull
    private PlaceholderSetting placeholderSetting;

    APIHologram(ImmutablePosition position, Plugin plugin, APIHologramManager hologramManager, LineTrackerManager lineTrackerManager) {
        super(position, lineTrackerManager);
        Preconditions.notNull((Object)plugin, (String)"plugin");
        this.lines = new APIHologramLines(this, lineTrackerManager);
        this.plugin = plugin;
        this.hologramManager = hologramManager;
        this.placeholderSetting = PlaceholderSetting.DEFAULT;
    }

    @NotNull
    public APIHologramLines getLines() {
        return this.lines;
    }

    public void setPosition(@NotNull Position position) {
        super.setPosition(ImmutablePosition.of(position));
    }

    @NotNull
    public PlaceholderSetting getPlaceholderSetting() {
        return this.placeholderSetting;
    }

    public void setPlaceholderSetting(@NotNull PlaceholderSetting placeholderSetting) {
        CorePreconditions.checkMainThread();
        Preconditions.notNull((Object)placeholderSetting, (String)"placeholderSetting");
        this.checkNotDeleted();
        if (this.placeholderSetting == placeholderSetting) {
            return;
        }
        this.placeholderSetting = placeholderSetting;
        for (APIHologramLine line : this.lines) {
            line.setChanged();
        }
    }

    @Override
    public Plugin getCreatorPlugin() {
        return this.plugin;
    }

    public void delete() {
        this.hologramManager.deleteHologram(this);
    }
}

