/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tracking;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import me.filoghost.fcommons.logging.Log;

public class PacketSenderExecutor {
    private static volatile BlockingQueue<Runnable> tasks;
    private static final Runnable STOP_MARKER_TASK;

    public static void execute(Runnable task) {
        tasks.add(task);
    }

    public static void start() {
        tasks = new LinkedBlockingQueue<Runnable>();
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Runnable task;
                        if ((task = tasks.take()) == STOP_MARKER_TASK) {
                            return;
                        }
                        task.run();
                    }
                }
                catch (Throwable t) {
                    Log.severe((String)"Error in packet sender task", (Throwable)t);
                    continue;
                }
                break;
            }
        });
        thread.setName("Holographic Displays async packets");
        thread.start();
    }

    public static void stopGracefully() {
        if (tasks != null) {
            tasks.add(STOP_MARKER_TASK);
        }
    }

    static {
        STOP_MARKER_TASK = () -> {};
    }
}

