/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tick;

import java.util.Map;
import java.util.function.BiPredicate;
import me.filoghost.holographicdisplays.core.tick.TickExpiringValue;

public class TickExpiringMap<K, V extends TickExpiringValue> {
    private final Map<K, V> map;
    private final long expirationTicks;

    public TickExpiringMap(Map<K, V> map, long expirationTicks) {
        this.map = map;
        this.expirationTicks = expirationTicks;
    }

    public void removeEntries(BiPredicate<? super K, ? super V> filter) {
        this.map.entrySet().removeIf(entry -> filter.test((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public void clearUnusedEntries(long currentTick) {
        this.map.values().removeIf(value -> currentTick - value.getLastUseTick() >= this.expirationTicks);
    }

    public V get(K key) {
        return (V)((TickExpiringValue)this.map.get(key));
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }
}

