/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.placeholder.registry;

import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholder;
import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholderFactory;
import me.filoghost.holographicdisplays.core.placeholder.PlaceholderException;
import me.filoghost.holographicdisplays.core.placeholder.StandardPlaceholder;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IndividualPlaceholderExpansion
extends PlaceholderExpansion {
    private final IndividualPlaceholderFactory placeholderFactory;

    IndividualPlaceholderExpansion(Plugin plugin, String identifier, IndividualPlaceholderFactory placeholderFactory) {
        super(plugin, identifier);
        this.placeholderFactory = placeholderFactory;
    }

    @Override
    public boolean isIndividual() {
        return true;
    }

    @Override
    @Nullable
    public StandardPlaceholder createPlaceholder(String argument) throws PlaceholderException {
        IndividualPlaceholder placeholder;
        try {
            placeholder = this.placeholderFactory.getPlaceholder(argument);
        }
        catch (Throwable t) {
            throw new PlaceholderException(t, this);
        }
        if (placeholder != null) {
            return new IndividualStandardPlaceholder(placeholder, this);
        }
        return null;
    }

    private static class IndividualStandardPlaceholder
    extends StandardPlaceholder {
        @NotNull
        private final IndividualPlaceholder placeholder;

        IndividualStandardPlaceholder(@NotNull IndividualPlaceholder placeholder, @NotNull IndividualPlaceholderExpansion source) {
            super(source);
            this.placeholder = placeholder;
        }

        @Override
        protected int doGetRefreshIntervalTicks() {
            return this.placeholder.getRefreshIntervalTicks();
        }

        @Override
        @Nullable
        protected String doGetReplacement(Player player, @Nullable String argument) {
            return this.placeholder.getReplacement(player, argument);
        }
    }
}

