/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.placeholder.parsing;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import me.filoghost.holographicdisplays.core.placeholder.PlaceholderOccurrence;
import me.filoghost.holographicdisplays.core.placeholder.parsing.Parser;
import me.filoghost.holographicdisplays.core.placeholder.parsing.Part;
import me.filoghost.holographicdisplays.core.placeholder.parsing.PlaceholderPart;
import me.filoghost.holographicdisplays.core.placeholder.parsing.PlaceholderReplaceFunction;
import me.filoghost.holographicdisplays.core.placeholder.parsing.StringPart;
import me.filoghost.holographicdisplays.core.placeholder.parsing.StringReplaceFunction;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringWithPlaceholders {
    @NotNull
    private final String string;
    @Nullable
    private final List<Part> parts;

    @NotNull
    public static StringWithPlaceholders of(@NotNull String string) {
        return Parser.parse(string, false);
    }

    @NotNull
    public static StringWithPlaceholders withEscapes(@NotNull String string) {
        return Parser.parse(string, true);
    }

    public static String addEscapes(@NotNull String string) {
        return Parser.addEscapes(string);
    }

    StringWithPlaceholders(@NotNull String string, @Nullable List<Part> parts) {
        this.string = string;
        this.parts = parts;
    }

    @NotNull
    public String getString() {
        return this.string;
    }

    public boolean containsPlaceholders() {
        if (this.parts == null) {
            return false;
        }
        for (Part part : this.parts) {
            if (!(part instanceof PlaceholderPart)) continue;
            return true;
        }
        return false;
    }

    public boolean anyPlaceholderMatch(Predicate<PlaceholderOccurrence> filter) {
        if (this.parts == null) {
            return false;
        }
        for (Part part : this.parts) {
            PlaceholderPart placeholderPart;
            if (!(part instanceof PlaceholderPart) || !filter.test((placeholderPart = (PlaceholderPart)part).getPlaceholderOccurrence())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String replacePlaceholders(Player player, PlaceholderReplaceFunction replaceFunction) {
        return this.replace(player, replaceFunction, StringReplaceFunction.NO_REPLACEMENTS);
    }

    @NotNull
    public String replaceOutsidePlaceholders(StringReplaceFunction replaceFunction) {
        return this.replace(null, PlaceholderReplaceFunction.NO_REPLACEMENTS, replaceFunction);
    }

    @NotNull
    private String replace(Player player, PlaceholderReplaceFunction placeholderReplaceFunction, StringReplaceFunction literalPartReplaceFunction) {
        if (this.parts == null) {
            return literalPartReplaceFunction.getReplacement(this.string);
        }
        StringBuilder output = new StringBuilder(this.string.length());
        for (Part part : this.parts) {
            String replacement;
            if (part instanceof StringPart) {
                replacement = ((StringPart)part).getValue(literalPartReplaceFunction);
            } else if (part instanceof PlaceholderPart) {
                replacement = ((PlaceholderPart)part).getValue(player, placeholderReplaceFunction);
            } else {
                throw new AssertionError();
            }
            output.append(replacement);
        }
        return output.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StringWithPlaceholders other = (StringWithPlaceholders)obj;
        return Objects.equals(this.string, other.string);
    }

    public int hashCode() {
        return Objects.hashCode(this.string);
    }
}

