/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.current;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import me.filoghost.fcommons.Preconditions;
import me.filoghost.holographicdisplays.api.hologram.VisibilitySettings;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DefaultVisibilitySettings
implements VisibilitySettings {
    private final AtomicInteger version = new AtomicInteger();
    private VisibilitySettings.Visibility globalVisibility = VisibilitySettings.Visibility.VISIBLE;
    private Map<UUID, VisibilitySettings.Visibility> individualVisibilities;

    @NotNull
    public VisibilitySettings.Visibility getGlobalVisibility() {
        return this.globalVisibility;
    }

    public void setGlobalVisibility(@NotNull VisibilitySettings.Visibility visibility) {
        if (this.globalVisibility == visibility) {
            return;
        }
        this.globalVisibility = visibility;
        this.version.incrementAndGet();
    }

    public void setIndividualVisibility(@NotNull Player player, @NotNull VisibilitySettings.Visibility visibility) {
        VisibilitySettings.Visibility previousVisibility;
        if (this.individualVisibilities == null) {
            this.individualVisibilities = new ConcurrentHashMap<UUID, VisibilitySettings.Visibility>();
        }
        if (visibility != (previousVisibility = this.individualVisibilities.put(player.getUniqueId(), visibility))) {
            this.version.incrementAndGet();
        }
    }

    public boolean isVisibleTo(@NotNull Player player) {
        Preconditions.notNull((Object)player, (String)"player");
        return this.getVisibility(player) == VisibilitySettings.Visibility.VISIBLE;
    }

    private VisibilitySettings.Visibility getVisibility(Player player) {
        VisibilitySettings.Visibility visibility;
        if (this.individualVisibilities != null && (visibility = this.individualVisibilities.get(player.getUniqueId())) != null) {
            return visibility;
        }
        return this.globalVisibility;
    }

    public void removeIndividualVisibility(@NotNull Player player) {
        Preconditions.notNull((Object)player, (String)"player");
        if (this.individualVisibilities == null) {
            return;
        }
        VisibilitySettings.Visibility previousVisibility = this.individualVisibilities.remove(player.getUniqueId());
        if (previousVisibility != null) {
            this.version.incrementAndGet();
        }
    }

    public void clearIndividualVisibilities() {
        if (this.individualVisibilities == null || this.individualVisibilities.isEmpty()) {
            return;
        }
        this.individualVisibilities.clear();
        this.version.incrementAndGet();
    }

    public int getVersion() {
        return this.version.get();
    }

    public String toString() {
        return "VisibilitySettings{globalVisibility=" + this.globalVisibility + ", individualVisibilities=" + this.individualVisibilities + "}";
    }
}

