/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tracking;

import java.util.Objects;
import me.filoghost.holographicdisplays.core.tick.CachedPlayer;
import me.filoghost.holographicdisplays.core.tracking.DisplayText;
import me.filoghost.holographicdisplays.core.tracking.Viewer;
import me.filoghost.holographicdisplays.nms.common.IndividualTextPacketGroup;

class TextLineViewer
extends Viewer {
    private final DisplayText displayText;
    private String individualText;
    private String lastSentText;
    private String nextTextToSend;

    TextLineViewer(CachedPlayer player, DisplayText displayText) {
        super(player);
        this.displayText = displayText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTextPackets(IndividualTextPacketGroup packets) {
        String text;
        TextLineViewer textLineViewer = this;
        synchronized (textLineViewer) {
            this.lastSentText = text = this.nextTextToSend;
        }
        this.sendIndividualPackets(packets, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTextPacketsIfNecessary(IndividualTextPacketGroup packets) {
        String text;
        TextLineViewer textLineViewer = this;
        synchronized (textLineViewer) {
            text = this.nextTextToSend;
            if (Objects.equals(this.lastSentText, text)) {
                return;
            }
            this.lastSentText = text;
        }
        this.sendIndividualPackets(packets, text);
    }

    public synchronized void updateNextTextToSend() {
        if (this.displayText.containsIndividualPlaceholders()) {
            if (this.individualText == null) {
                this.individualText = this.displayText.computeIndividualText(this);
            }
            this.nextTextToSend = this.individualText;
        } else {
            this.individualText = null;
            this.nextTextToSend = this.displayText.getGlobalText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateIndividualText() {
        String individualText = this.displayText.computeIndividualText(this);
        TextLineViewer textLineViewer = this;
        synchronized (textLineViewer) {
            if (!Objects.equals(this.individualText, individualText)) {
                this.individualText = individualText;
                return true;
            }
            return false;
        }
    }
}

