/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.current;

import java.util.Collection;
import me.filoghost.fcommons.Preconditions;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import me.filoghost.holographicdisplays.api.placeholder.GlobalPlaceholder;
import me.filoghost.holographicdisplays.api.placeholder.GlobalPlaceholderFactory;
import me.filoghost.holographicdisplays.api.placeholder.GlobalPlaceholderReplaceFunction;
import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholder;
import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholderFactory;
import me.filoghost.holographicdisplays.api.placeholder.IndividualPlaceholderReplaceFunction;
import me.filoghost.holographicdisplays.core.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderRegistry;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

class DefaultHolographicDisplaysAPI
implements HolographicDisplaysAPI {
    private final Plugin plugin;
    private final APIHologramManager apiHologramManager;
    private final PlaceholderRegistry placeholderRegistry;

    DefaultHolographicDisplaysAPI(Plugin plugin, APIHologramManager apiHologramManager, PlaceholderRegistry placeholderRegistry) {
        this.plugin = plugin;
        this.apiHologramManager = apiHologramManager;
        this.placeholderRegistry = placeholderRegistry;
    }

    @NotNull
    public Hologram createHologram(@NotNull Location location) {
        Preconditions.notNull((Object)location, (String)"location");
        Preconditions.notNull((Object)location.getWorld(), (String)"location.getWorld()");
        return this.apiHologramManager.createHologram(ImmutablePosition.of(location), this.plugin);
    }

    @NotNull
    public Hologram createHologram(@NotNull Position position) {
        Preconditions.notNull((Object)position, (String)"position");
        Preconditions.notNull((Object)position.getWorldName(), (String)"position.getWorldName()");
        return this.apiHologramManager.createHologram(ImmutablePosition.of(position), this.plugin);
    }

    public void registerGlobalPlaceholder(@NotNull String identifier, int refreshIntervalTicks, @NotNull GlobalPlaceholderReplaceFunction replaceFunction) {
        this.checkIdentifier(identifier);
        Preconditions.checkArgument((refreshIntervalTicks >= 0 ? 1 : 0) != 0, (String)"refreshIntervalTicks should be positive");
        Preconditions.notNull((Object)replaceFunction, (String)"replaceFunction");
        this.placeholderRegistry.registerGlobalPlaceholder(this.plugin, identifier, refreshIntervalTicks, replaceFunction);
    }

    public void registerGlobalPlaceholder(@NotNull String identifier, @NotNull GlobalPlaceholder placeholder) {
        this.checkIdentifier(identifier);
        Preconditions.notNull((Object)placeholder, (String)"placeholder");
        this.placeholderRegistry.registerGlobalPlaceholder(this.plugin, identifier, placeholder);
    }

    public void registerGlobalPlaceholderFactory(@NotNull String identifier, @NotNull GlobalPlaceholderFactory placeholderFactory) {
        this.checkIdentifier(identifier);
        Preconditions.notNull((Object)placeholderFactory, (String)"placeholderFactory");
        this.placeholderRegistry.registerGlobalPlaceholderFactory(this.plugin, identifier, placeholderFactory);
    }

    public void registerIndividualPlaceholder(@NotNull String identifier, int refreshIntervalTicks, @NotNull IndividualPlaceholderReplaceFunction replaceFunction) {
        this.checkIdentifier(identifier);
        Preconditions.checkArgument((refreshIntervalTicks >= 0 ? 1 : 0) != 0, (String)"refreshIntervalTicks should be positive");
        Preconditions.notNull((Object)replaceFunction, (String)"replaceFunction");
        this.placeholderRegistry.registerIndividualPlaceholder(this.plugin, identifier, refreshIntervalTicks, replaceFunction);
    }

    public void registerIndividualPlaceholder(@NotNull String identifier, @NotNull IndividualPlaceholder placeholder) {
        this.checkIdentifier(identifier);
        Preconditions.notNull((Object)placeholder, (String)"placeholder");
        this.placeholderRegistry.registerIndividualPlaceholder(this.plugin, identifier, placeholder);
    }

    public void registerIndividualPlaceholderFactory(@NotNull String identifier, @NotNull IndividualPlaceholderFactory placeholderFactory) {
        this.checkIdentifier(identifier);
        Preconditions.notNull((Object)placeholderFactory, (String)"placeholderFactory");
        this.placeholderRegistry.registerIndividualPlaceholderFactory(this.plugin, identifier, placeholderFactory);
    }

    private void checkIdentifier(String identifier) {
        Preconditions.notEmpty((String)identifier, (String)"identifier");
        for (char c : identifier.toCharArray()) {
            Preconditions.checkArgument((boolean)this.isValidIdentifierCharacter(c), (String)("identifier contains invalid character '" + c + "'"));
        }
    }

    private boolean isValidIdentifierCharacter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '_';
    }

    public boolean isRegisteredPlaceholder(@NotNull String identifier) {
        Preconditions.notNull((Object)identifier, (String)"identifier");
        return this.placeholderRegistry.isRegisteredIdentifier(this.plugin, identifier);
    }

    @NotNull
    public Collection<Hologram> getHolograms() {
        return this.apiHologramManager.getHologramsByPlugin(this.plugin);
    }

    public void deleteHolograms() {
        this.apiHologramManager.deleteHologramsIf(apiHologram -> apiHologram.getCreatorPlugin().equals((Object)this.plugin));
    }

    @NotNull
    public Collection<String> getRegisteredPlaceholders() {
        return this.placeholderRegistry.getRegisteredPlaceholders(this.plugin);
    }

    public void unregisterPlaceholder(@NotNull String identifier) {
        Preconditions.notNull((Object)identifier, (String)"identifier");
        this.placeholderRegistry.unregister(this.plugin, identifier);
    }

    public void unregisterPlaceholders() {
        this.placeholderRegistry.unregisterAll(this.plugin);
    }
}

