/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tracking;

import me.filoghost.holographicdisplays.common.PositionCoordinates;
import me.filoghost.holographicdisplays.core.base.BaseClickableHologramLine;
import me.filoghost.holographicdisplays.core.listener.LineClickListener;
import me.filoghost.holographicdisplays.core.tracking.LineTracker;
import me.filoghost.holographicdisplays.core.tracking.PacketSenderExecutor;
import me.filoghost.holographicdisplays.core.tracking.Viewer;
import me.filoghost.holographicdisplays.core.tracking.Viewers;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.common.entity.ClickableNMSPacketEntity;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class ClickableLineTracker<T extends Viewer>
extends LineTracker<T> {
    private final ClickableNMSPacketEntity clickableEntity;
    private final double positionOffsetY;
    private final LineClickListener lineClickListener;
    private boolean spawnClickableEntity;
    private boolean spawnClickableEntityChanged;

    public ClickableLineTracker(BaseClickableHologramLine line, NMSManager nmsManager, LineClickListener lineClickListener) {
        this.clickableEntity = nmsManager.newClickablePacketEntity();
        this.positionOffsetY = (line.getHeight() - 0.5) / 2.0;
        this.lineClickListener = lineClickListener;
    }

    public void onClientClick(Player player) {
        if (this.getLine().hasClickCallback() && this.canInteract(player) && this.isInClickRange(player)) {
            this.getLine().onClick(player);
        }
    }

    private boolean isInClickRange(Player player) {
        double zDiff;
        double yDiff;
        Location playerLocation = player.getLocation();
        PositionCoordinates positionCoordinates = this.getLine().getCoordinates();
        double xDiff = playerLocation.getX() - positionCoordinates.getX();
        double distanceSquared = xDiff * xDiff + (yDiff = playerLocation.getY() + 1.3 - positionCoordinates.getY()) * yDiff + (zDiff = playerLocation.getZ() - positionCoordinates.getZ()) * zDiff;
        return distanceSquared < 25.0;
    }

    @Override
    public abstract BaseClickableHologramLine getLine();

    @Override
    @MustBeInvokedByOverriders
    public void onRemoval() {
        super.onRemoval();
        this.lineClickListener.removeLineTracker(this.clickableEntity.getID());
    }

    @Override
    @MustBeInvokedByOverriders
    protected void detectChanges() {
        super.detectChanges();
        boolean spawnClickableEntity = this.getLine().hasClickCallback();
        if (this.spawnClickableEntity != spawnClickableEntity) {
            this.spawnClickableEntity = spawnClickableEntity;
            this.spawnClickableEntityChanged = true;
            if (spawnClickableEntity) {
                this.lineClickListener.addLineTracker(this.clickableEntity.getID(), this);
            } else {
                this.lineClickListener.removeLineTracker(this.clickableEntity.getID());
            }
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void clearDetectedChanges() {
        super.clearDetectedChanges();
        this.spawnClickableEntityChanged = false;
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendSpawnPackets(Viewers<T> viewers) {
        if (this.spawnClickableEntity) {
            PositionCoordinates clickableEntityPosition = this.getClickableEntityPosition();
            PacketSenderExecutor.execute(() -> viewers.sendPackets(this.clickableEntity.newSpawnPackets(clickableEntityPosition)));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendDestroyPackets(Viewers<T> viewers) {
        if (this.spawnClickableEntity) {
            PacketSenderExecutor.execute(() -> viewers.sendPackets(this.clickableEntity.newDestroyPackets()));
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendChangesPackets(Viewers<T> viewers) {
        super.sendChangesPackets(viewers);
        if (this.spawnClickableEntityChanged) {
            if (this.spawnClickableEntity) {
                PositionCoordinates clickableEntityPosition = this.getClickableEntityPosition();
                PacketSenderExecutor.execute(() -> viewers.sendPackets(this.clickableEntity.newSpawnPackets(clickableEntityPosition)));
            } else {
                PacketSenderExecutor.execute(() -> viewers.sendPackets(this.clickableEntity.newDestroyPackets()));
            }
        }
    }

    @Override
    @MustBeInvokedByOverriders
    protected void sendPositionChangePackets(Viewers<T> viewers) {
        if (this.spawnClickableEntity) {
            PositionCoordinates clickableEntityPosition = this.getClickableEntityPosition();
            PacketSenderExecutor.execute(() -> viewers.sendPackets(this.clickableEntity.newTeleportPackets(clickableEntityPosition)));
        }
    }

    private PositionCoordinates getClickableEntityPosition() {
        return this.positionCoordinates.addY(this.positionOffsetY);
    }
}

