/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.tick;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.filoghost.fcommons.logging.Log;
import me.filoghost.holographicdisplays.core.CoreGlobalConfig;
import me.filoghost.holographicdisplays.core.NMSVersion;
import me.filoghost.holographicdisplays.core.listener.LineClickListener;
import me.filoghost.holographicdisplays.core.placeholder.tracking.ActivePlaceholderTracker;
import me.filoghost.holographicdisplays.core.tick.CachedPlayer;
import me.filoghost.holographicdisplays.core.tick.TickClock;
import me.filoghost.holographicdisplays.core.tracking.LineTrackerManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TickingTask
implements Runnable {
    private final TickClock tickClock;
    private final ActivePlaceholderTracker placeholderTracker;
    private final LineTrackerManager lineTrackerManager;
    private final LineClickListener lineClickListener;
    private final List<CachedPlayer> onlinePlayers;
    private long lastErrorLogTick;

    public TickingTask(TickClock tickClock, ActivePlaceholderTracker placeholderTracker, LineTrackerManager lineTrackerManager, LineClickListener lineClickListener) {
        this.tickClock = tickClock;
        this.placeholderTracker = placeholderTracker;
        this.lineTrackerManager = lineTrackerManager;
        this.lineClickListener = lineClickListener;
        this.onlinePlayers = new ArrayList<CachedPlayer>();
    }

    public void onPlayerJoin(Player player) {
        this.onlinePlayers.add(new CachedPlayer(player));
    }

    public void onPlayerQuit(Player player) {
        Iterator<CachedPlayer> iterator = this.onlinePlayers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getBukkitPlayer() != player) continue;
            iterator.remove();
            break;
        }
        this.lineTrackerManager.removeViewer(player);
    }

    public void onPlayerRespawn(Player player) {
        switch (NMSVersion.getCurrent()) {
            case v1_12_R1: 
            case v1_13_R1: 
            case v1_13_R2: 
            case v1_14_R1: {
                this.lineTrackerManager.removeViewer(player);
                break;
            }
        }
    }

    @Override
    public void run() {
        block5: {
            this.tickClock.incrementTick();
            this.placeholderTracker.clearOutdatedEntries();
            ArrayList<CachedPlayer> movedPlayers = new ArrayList<CachedPlayer>();
            for (CachedPlayer onlinePlayer : this.onlinePlayers) {
                if (!onlinePlayer.isMovedLastTick()) continue;
                movedPlayers.add(onlinePlayer);
            }
            int maxViewRange = (Bukkit.getViewDistance() - 1) * 16;
            if (maxViewRange > CoreGlobalConfig.maxViewRange) {
                maxViewRange = CoreGlobalConfig.maxViewRange;
            }
            try {
                this.lineTrackerManager.update(this.onlinePlayers, movedPlayers, maxViewRange);
            }
            catch (Throwable t) {
                if (this.tickClock.getCurrentTick() - this.lastErrorLogTick < 20L) break block5;
                this.lastErrorLogTick = this.tickClock.getCurrentTick();
                Log.severe((String)"Error while ticking holograms", (Throwable)t);
            }
        }
        this.placeholderTracker.clearInactivePlaceholders();
        this.lineClickListener.processQueuedClickEvents();
        for (CachedPlayer onlinePlayer : this.onlinePlayers) {
            onlinePlayer.onTick();
        }
    }
}

