/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.current;

import me.filoghost.fcommons.Preconditions;
import me.filoghost.holographicdisplays.api.hologram.HologramLines;
import me.filoghost.holographicdisplays.api.hologram.line.HologramLine;
import me.filoghost.holographicdisplays.api.hologram.line.ItemHologramLine;
import me.filoghost.holographicdisplays.api.hologram.line.TextHologramLine;
import me.filoghost.holographicdisplays.core.api.current.APIHologram;
import me.filoghost.holographicdisplays.core.api.current.APIHologramLine;
import me.filoghost.holographicdisplays.core.api.current.APIItemHologramLine;
import me.filoghost.holographicdisplays.core.api.current.APITextHologramLine;
import me.filoghost.holographicdisplays.core.base.BaseHologramLines;
import me.filoghost.holographicdisplays.core.tracking.LineTrackerManager;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class APIHologramLines
extends BaseHologramLines<APIHologramLine>
implements HologramLines {
    private final APIHologram hologram;

    APIHologramLines(APIHologram hologram, LineTrackerManager lineTrackerManager) {
        super(hologram, lineTrackerManager);
        this.hologram = hologram;
    }

    @NotNull
    public TextHologramLine appendText(@Nullable String text) {
        this.checkNotDeleted();
        APITextHologramLine line = new APITextHologramLine(this.hologram, text);
        super.add(line);
        return line;
    }

    @NotNull
    public ItemHologramLine appendItem(@Nullable ItemStack itemStack) {
        this.checkNotDeleted();
        APIItemHologramLine line = new APIItemHologramLine(this.hologram, itemStack);
        super.add(line);
        return line;
    }

    @NotNull
    public TextHologramLine insertText(int beforeIndex, @Nullable String text) {
        this.checkNotDeleted();
        APITextHologramLine line = new APITextHologramLine(this.hologram, text);
        super.insert(beforeIndex, line);
        return line;
    }

    @NotNull
    public ItemHologramLine insertItem(int beforeIndex, @NotNull ItemStack itemStack) {
        Preconditions.notNull((Object)itemStack, (String)"itemStack");
        this.checkNotDeleted();
        APIItemHologramLine line = new APIItemHologramLine(this.hologram, itemStack);
        super.insert(beforeIndex, line);
        return line;
    }

    @Override
    public boolean remove(@NotNull HologramLine line) {
        if (line instanceof APIHologramLine) {
            return super.remove((APIHologramLine)line);
        }
        return false;
    }
}

