/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.filoghost.fcommons.logging.ErrorCollector;
import me.filoghost.holographicdisplays.nms.common.NMSManager;
import me.filoghost.holographicdisplays.nms.v1_19_R2.VersionNMSManager;
import org.bukkit.Bukkit;

public enum NMSVersion {
    v1_12_R1(me.filoghost.holographicdisplays.nms.v1_12_R1.VersionNMSManager::new),
    v1_13_R1(NMSManagerFactory.outdatedVersion("1.13.1")),
    v1_13_R2(me.filoghost.holographicdisplays.nms.v1_13_R2.VersionNMSManager::new),
    v1_14_R1(me.filoghost.holographicdisplays.nms.v1_14_R1.VersionNMSManager::new),
    v1_15_R1(me.filoghost.holographicdisplays.nms.v1_15_R1.VersionNMSManager::new),
    v1_16_R1(NMSManagerFactory.outdatedVersion("1.16.4")),
    v1_16_R2(NMSManagerFactory.outdatedVersion("1.16.4")),
    v1_16_R3(me.filoghost.holographicdisplays.nms.v1_16_R3.VersionNMSManager::new),
    v1_17_R1(me.filoghost.holographicdisplays.nms.v1_17_R1.VersionNMSManager::new),
    v1_18_R1(me.filoghost.holographicdisplays.nms.v1_18_R1.VersionNMSManager::new),
    v1_18_R2(me.filoghost.holographicdisplays.nms.v1_18_R2.VersionNMSManager::new),
    v1_19_R1(me.filoghost.holographicdisplays.nms.v1_19_R1.VersionNMSManager::new),
    v1_19_R2(VersionNMSManager::new),
    v1_19_R3(me.filoghost.holographicdisplays.nms.v1_19_R3.VersionNMSManager::new),
    v1_20_R1(me.filoghost.holographicdisplays.nms.v1_20_R1.VersionNMSManager::new),
    v1_20_R2(me.filoghost.holographicdisplays.nms.v1_20_R2.VersionNMSManager::new),
    v1_20_R3(me.filoghost.holographicdisplays.nms.v1_20_R3.VersionNMSManager::new),
    v1_20_R4(me.filoghost.holographicdisplays.nms.v1_20_R4.VersionNMSManager::new),
    v1_21_R1(me.filoghost.holographicdisplays.nms.v1_21_R1.VersionNMSManager::new),
    v1_21_R2(me.filoghost.holographicdisplays.nms.v1_21_R2.VersionNMSManager::new),
    v1_21_R3(me.filoghost.holographicdisplays.nms.v1_21_R3.VersionNMSManager::new),
    v1_21_R4(me.filoghost.holographicdisplays.nms.v1_21_R4.VersionNMSManager::new),
    v1_21_R5(me.filoghost.holographicdisplays.nms.v1_21_R5.VersionNMSManager::new),
    UNKNOWN(NMSManagerFactory.unknownVersion());

    private static final NMSVersion CURRENT_VERSION;
    private final NMSManagerFactory nmsManagerFactory;

    private NMSVersion(NMSManagerFactory nmsManagerFactory) {
        this.nmsManagerFactory = nmsManagerFactory;
    }

    public NMSManager createNMSManager(ErrorCollector errorCollector) throws OutdatedVersionException, UnknownVersionException {
        return this.nmsManagerFactory.create(errorCollector);
    }

    public static NMSVersion getCurrent() {
        return CURRENT_VERSION;
    }

    private static NMSVersion detectCurrentVersion() {
        String bukkitVersion = Bukkit.getServer().getBukkitVersion();
        int majorVersion = Integer.parseInt(bukkitVersion.split("[.-]")[1]);
        if (majorVersion >= 20) {
            switch (bukkitVersion) {
                case "1.20-R0.1-SNAPSHOT": 
                case "1.20.1-R0.1-SNAPSHOT": {
                    return v1_20_R1;
                }
                case "1.20.2-R0.1-SNAPSHOT": {
                    return v1_20_R2;
                }
                case "1.20.3-R0.1-SNAPSHOT": 
                case "1.20.4-R0.1-SNAPSHOT": {
                    return v1_20_R3;
                }
                case "1.20.5-R0.1-SNAPSHOT": 
                case "1.20.6-R0.1-SNAPSHOT": {
                    return v1_20_R4;
                }
                case "1.21-R0.1-SNAPSHOT": 
                case "1.21.1-R0.1-SNAPSHOT": {
                    return v1_21_R1;
                }
                case "1.21.2-R0.1-SNAPSHOT": 
                case "1.21.3-R0.1-SNAPSHOT": {
                    return v1_21_R2;
                }
                case "1.21.4-R0.1-SNAPSHOT": {
                    return v1_21_R3;
                }
                case "1.21.5-R0.1-SNAPSHOT": {
                    return v1_21_R4;
                }
                case "1.21.6-R0.1-SNAPSHOT": 
                case "1.21.7-R0.1-SNAPSHOT": 
                case "1.21.8-R0.1-SNAPSHOT": {
                    return v1_21_R5;
                }
            }
            return UNKNOWN;
        }
        Matcher matcher = Pattern.compile("v\\d+_\\d+_R\\d+").matcher(Bukkit.getServer().getClass().getPackage().getName());
        if (!matcher.find()) {
            return UNKNOWN;
        }
        String nmsVersionName = matcher.group();
        try {
            return NMSVersion.valueOf(nmsVersionName);
        }
        catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }

    static {
        CURRENT_VERSION = NMSVersion.detectCurrentVersion();
    }

    @FunctionalInterface
    private static interface NMSManagerFactory {
        public NMSManager create(ErrorCollector var1) throws UnknownVersionException, OutdatedVersionException;

        public static NMSManagerFactory unknownVersion() {
            return errorCollector -> {
                throw new UnknownVersionException();
            };
        }

        public static NMSManagerFactory outdatedVersion(String minimumSupportedVersion) {
            return errorCollector -> {
                throw new OutdatedVersionException(minimumSupportedVersion);
            };
        }
    }

    public static class OutdatedVersionException
    extends Exception {
        private final String minimumSupportedVersion;

        public OutdatedVersionException(String minimumSupportedVersion) {
            this.minimumSupportedVersion = minimumSupportedVersion;
        }

        public String getMinimumSupportedVersion() {
            return this.minimumSupportedVersion;
        }
    }

    public static class UnknownVersionException
    extends Exception {
    }
}

