/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.placeholder;

import me.filoghost.holographicdisplays.core.placeholder.PlaceholderException;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StandardPlaceholder {
    @NotNull
    private final PlaceholderExpansion source;

    protected StandardPlaceholder(@NotNull PlaceholderExpansion source) {
        this.source = source;
    }

    @NotNull
    public final PlaceholderExpansion getSource() {
        return this.source;
    }

    public boolean isIndividual() {
        return this.source.isIndividual();
    }

    public final int getRefreshIntervalTicks() throws PlaceholderException {
        try {
            return this.doGetRefreshIntervalTicks();
        }
        catch (Throwable t) {
            throw new PlaceholderException(t, this.getSource());
        }
    }

    @Nullable
    public final String getReplacement(Player player, @Nullable String argument) throws PlaceholderException {
        try {
            return this.doGetReplacement(player, argument);
        }
        catch (Throwable t) {
            throw new PlaceholderException(t, this.getSource());
        }
    }

    protected abstract int doGetRefreshIntervalTicks() throws Throwable;

    @Nullable
    protected abstract String doGetReplacement(Player var1, @Nullable String var2) throws Throwable;
}

