/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.base;

import me.filoghost.fcommons.Preconditions;
import me.filoghost.holographicdisplays.common.PositionCoordinates;
import me.filoghost.holographicdisplays.core.api.current.DefaultVisibilitySettings;
import me.filoghost.holographicdisplays.core.base.BaseHologram;
import me.filoghost.holographicdisplays.core.base.BaseHologramComponent;
import me.filoghost.holographicdisplays.core.base.EditableHologramLine;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseHologramLine
extends BaseHologramComponent
implements EditableHologramLine {
    private final BaseHologram hologram;
    private PositionCoordinates coordinates;
    private boolean changed;

    protected BaseHologramLine(BaseHologram hologram) {
        Preconditions.notNull((Object)hologram, (String)"hologram");
        this.hologram = hologram;
        this.setChanged();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public final void setChanged() {
        this.changed = true;
    }

    public void clearChanged() {
        this.changed = false;
    }

    @Override
    public final void setCoordinates(double x, double y, double z) {
        this.coordinates = new PositionCoordinates(x, y, z);
        this.setChanged();
    }

    @NotNull
    public PositionCoordinates getCoordinates() {
        if (this.coordinates == null) {
            throw new IllegalStateException("position not set");
        }
        return this.coordinates;
    }

    @NotNull
    public String getWorldName() {
        return this.hologram.getPosition().getWorldName();
    }

    @Nullable
    public World getWorldIfLoaded() {
        return this.hologram.getWorldIfLoaded();
    }

    public boolean isInLoadedChunk() {
        return this.hologram.isInLoadedChunk();
    }

    public final boolean isVisibleTo(Player player) {
        return this.hologram.getVisibilitySettings().isVisibleTo(player);
    }

    public final Plugin getCreatorPlugin() {
        return this.hologram.getCreatorPlugin();
    }

    public final DefaultVisibilitySettings getVisibilitySettings() {
        return this.hologram.getVisibilitySettings();
    }
}

