/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.base;

import me.filoghost.fcommons.Preconditions;
import me.filoghost.holographicdisplays.core.CorePreconditions;
import me.filoghost.holographicdisplays.core.api.current.DefaultVisibilitySettings;
import me.filoghost.holographicdisplays.core.base.BaseHologramComponent;
import me.filoghost.holographicdisplays.core.base.BaseHologramLines;
import me.filoghost.holographicdisplays.core.base.EditableHologramLine;
import me.filoghost.holographicdisplays.core.base.HologramPosition;
import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import me.filoghost.holographicdisplays.core.tracking.LineTrackerManager;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseHologram
extends BaseHologramComponent {
    private final HologramPosition hologramPosition;
    private final DefaultVisibilitySettings visibilitySettings;
    private final LineTrackerManager lineTrackerManager;

    public BaseHologram(ImmutablePosition position, LineTrackerManager lineTrackerManager) {
        this.hologramPosition = new HologramPosition(position);
        this.visibilitySettings = new DefaultVisibilitySettings();
        this.lineTrackerManager = lineTrackerManager;
    }

    public abstract BaseHologramLines<? extends EditableHologramLine> getLines();

    public abstract Plugin getCreatorPlugin();

    protected final LineTrackerManager getTrackerManager() {
        return this.lineTrackerManager;
    }

    @Override
    public final void setDeleted() {
        super.setDeleted();
        this.getLines().setDeleted();
    }

    @NotNull
    public ImmutablePosition getPosition() {
        return this.hologramPosition.getPosition();
    }

    @NotNull
    public DefaultVisibilitySettings getVisibilitySettings() {
        return this.visibilitySettings;
    }

    @Nullable
    public World getWorldIfLoaded() {
        return this.hologramPosition.getWorldIfLoaded();
    }

    public void setPosition(@NotNull Location location) {
        Preconditions.notNull((Object)location, (String)"location");
        Preconditions.notNull((Object)location.getWorld(), (String)"location.getWorld()");
        this.setPosition(location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    public void setPosition(@NotNull World world, double x, double y, double z) {
        Preconditions.notNull((Object)world, (String)"world");
        this.setPosition(world.getName(), x, y, z);
    }

    public void setPosition(@NotNull String worldName, double x, double y, double z) {
        Preconditions.notNull((Object)worldName, (String)"worldName");
        this.setPosition(new ImmutablePosition(worldName, x, y, z));
    }

    public void setPosition(@NotNull ImmutablePosition position) {
        CorePreconditions.checkMainThread();
        Preconditions.notNull((Object)position, (String)"position");
        this.checkNotDeleted();
        this.hologramPosition.set(position);
        this.getLines().updatePositions();
    }

    protected void onWorldLoad(World world) {
        this.hologramPosition.onWorldLoad(world);
    }

    protected void onWorldUnload(World world) {
        this.hologramPosition.onWorldUnload(world);
    }

    protected void onChunkLoad(Chunk chunk) {
        this.hologramPosition.onChunkLoad(chunk);
    }

    protected void onChunkUnload(Chunk chunk) {
        this.hologramPosition.onChunkUnload(chunk);
    }

    protected boolean isInLoadedChunk() {
        return this.hologramPosition.isChunkLoaded();
    }

    public String toString() {
        return "Hologram{position=" + this.hologramPosition + ", lines=" + this.getLines() + ", deleted=" + this.isDeleted() + "}";
    }
}

