/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.v2;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.internal.HologramsAPIProvider;
import com.gmail.filoghost.holographicdisplays.api.placeholder.PlaceholderReplacer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import me.filoghost.fcommons.Preconditions;
import me.filoghost.fcommons.collection.CollectionUtils;
import me.filoghost.holographicdisplays.core.api.v2.V2Hologram;
import me.filoghost.holographicdisplays.core.api.v2.V2HologramManager;
import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import me.filoghost.holographicdisplays.core.placeholder.registry.LegacyGlobalPlaceholderExpansion;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderRegistry;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class V2HologramsAPIProvider
extends HologramsAPIProvider {
    private final V2HologramManager hologramManager;
    private final PlaceholderRegistry placeholderRegistry;

    public V2HologramsAPIProvider(V2HologramManager hologramManager, PlaceholderRegistry placeholderRegistry) {
        this.hologramManager = hologramManager;
        this.placeholderRegistry = placeholderRegistry;
    }

    public Hologram createHologram(Plugin plugin, Location source) {
        Preconditions.notNull((Object)plugin, (String)"plugin");
        Preconditions.notNull((Object)source, (String)"source");
        Preconditions.notNull((Object)source.getWorld(), (String)"source.getWorld()");
        return this.hologramManager.createHologram(ImmutablePosition.of(source), plugin);
    }

    public Collection<Hologram> getHolograms(Plugin plugin) {
        Preconditions.notNull((Object)plugin, (String)"plugin");
        ArrayList<V2Hologram> ownedHolograms = new ArrayList<V2Hologram>();
        for (V2Hologram hologram : this.hologramManager.getHolograms()) {
            if (!hologram.getCreatorPlugin().equals((Object)plugin)) continue;
            ownedHolograms.add(hologram);
        }
        return Collections.unmodifiableList(ownedHolograms);
    }

    public boolean registerPlaceholder(Plugin plugin, String textPlaceholder, double refreshRate, PlaceholderReplacer replacer) {
        Preconditions.notNull((Object)plugin, (String)"plugin");
        Preconditions.notNull((Object)textPlaceholder, (String)"textPlaceholder");
        Preconditions.checkArgument((refreshRate >= 0.0 ? 1 : 0) != 0, (String)"refreshRate should be positive");
        Preconditions.notNull((Object)replacer, (String)"replacer");
        int refreshIntervalTicks = Math.min((int)(refreshRate * 20.0), 1);
        boolean alreadyRegistered = this.placeholderRegistry.isRegisteredLegacyPlaceholder(plugin, textPlaceholder);
        if (!alreadyRegistered) {
            this.placeholderRegistry.registerLegacyPlaceholder(plugin, textPlaceholder, refreshIntervalTicks, argument -> replacer.update());
            return true;
        }
        return false;
    }

    public Collection<String> getRegisteredPlaceholders(Plugin plugin) {
        Preconditions.notNull((Object)plugin, (String)"plugin");
        return CollectionUtils.toArrayList(this.placeholderRegistry.getRegisteredLegacyPlaceholders(plugin), LegacyGlobalPlaceholderExpansion::getTextPlaceholder);
    }

    public boolean unregisterPlaceholder(Plugin plugin, String textPlaceholder) {
        Preconditions.notNull((Object)plugin, (String)"plugin");
        Preconditions.notNull((Object)textPlaceholder, (String)"textPlaceholder");
        boolean registered = this.placeholderRegistry.isRegisteredLegacyPlaceholder(plugin, textPlaceholder);
        if (registered) {
            this.placeholderRegistry.unregisterLegacyPlaceholder(plugin, textPlaceholder);
            return true;
        }
        return false;
    }

    public void unregisterPlaceholders(Plugin plugin) {
        Preconditions.notNull((Object)plugin, (String)"plugin");
        this.placeholderRegistry.unregisterAllLegacyPlaceholders(plugin);
    }

    public boolean isHologramEntity(Entity bukkitEntity) {
        Preconditions.notNull((Object)bukkitEntity, (String)"bukkitEntity");
        return false;
    }
}

