/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.v2;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.VisibilityManager;
import com.gmail.filoghost.holographicdisplays.api.line.HologramLine;
import com.gmail.filoghost.holographicdisplays.api.line.ItemLine;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import me.filoghost.holographicdisplays.core.api.v2.V2HologramLine;
import me.filoghost.holographicdisplays.core.api.v2.V2HologramManager;
import me.filoghost.holographicdisplays.core.api.v2.V2ItemLine;
import me.filoghost.holographicdisplays.core.api.v2.V2TextLine;
import me.filoghost.holographicdisplays.core.api.v2.V2VisibilityManager;
import me.filoghost.holographicdisplays.core.base.BaseHologram;
import me.filoghost.holographicdisplays.core.base.BaseHologramLines;
import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import me.filoghost.holographicdisplays.core.tracking.LineTrackerManager;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class V2Hologram
extends BaseHologram
implements Hologram {
    private final Plugin plugin;
    private final V2HologramManager hologramManager;
    private final BaseHologramLines<V2HologramLine> lines;
    private final V2VisibilityManager visibilityManager;
    private final long creationTimestamp;
    private boolean allowPlaceholders;

    V2Hologram(ImmutablePosition position, Plugin plugin, LineTrackerManager lineTrackerManager, V2HologramManager hologramManager) {
        super(position, lineTrackerManager);
        this.plugin = plugin;
        this.hologramManager = hologramManager;
        this.lines = new BaseHologramLines(this, lineTrackerManager);
        this.visibilityManager = new V2VisibilityManager(this.getVisibilitySettings());
        this.creationTimestamp = System.currentTimeMillis();
    }

    public BaseHologramLines<V2HologramLine> getLines() {
        return this.lines;
    }

    @Override
    public Plugin getCreatorPlugin() {
        return this.plugin;
    }

    public TextLine appendTextLine(String text) {
        V2TextLine textLine = new V2TextLine(this, text);
        this.lines.add(textLine);
        return textLine;
    }

    public ItemLine appendItemLine(ItemStack itemStack) {
        V2ItemLine itemLine = new V2ItemLine(this, itemStack);
        this.lines.add(itemLine);
        return itemLine;
    }

    public TextLine insertTextLine(int index, String text) {
        V2TextLine textLine = new V2TextLine(this, text);
        this.lines.insert(index, textLine);
        return textLine;
    }

    public ItemLine insertItemLine(int index, ItemStack itemStack) {
        V2ItemLine itemLine = new V2ItemLine(this, itemStack);
        this.lines.insert(index, itemLine);
        return itemLine;
    }

    public HologramLine getLine(int index) {
        return this.lines.get(index);
    }

    public void removeLine(int index) {
        this.lines.remove(index);
    }

    public void clearLines() {
        this.lines.clear();
    }

    public int size() {
        return this.lines.size();
    }

    public double getHeight() {
        return this.lines.getHeight();
    }

    public void teleport(Location location) {
        super.setPosition(location);
    }

    public void teleport(World world, double x, double y, double z) {
        super.setPosition(world, x, y, z);
    }

    public Location getLocation() {
        return super.getPosition().toLocation();
    }

    public double getX() {
        return super.getPosition().getX();
    }

    public double getY() {
        return super.getPosition().getY();
    }

    public double getZ() {
        return super.getPosition().getZ();
    }

    public World getWorld() {
        return super.getWorldIfLoaded();
    }

    public VisibilityManager getVisibilityManager() {
        return this.visibilityManager;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public boolean isAllowPlaceholders() {
        return this.allowPlaceholders;
    }

    public void setAllowPlaceholders(boolean allowPlaceholders) {
        this.allowPlaceholders = allowPlaceholders;
    }

    public void delete() {
        this.hologramManager.deleteHologram(this);
    }
}

