/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.current;

import me.filoghost.holographicdisplays.api.hologram.line.HologramLineClickEvent;
import me.filoghost.holographicdisplays.api.hologram.line.HologramLineClickListener;
import me.filoghost.holographicdisplays.api.hologram.line.HologramLinePickupEvent;
import me.filoghost.holographicdisplays.api.hologram.line.HologramLinePickupListener;
import me.filoghost.holographicdisplays.api.hologram.line.ItemHologramLine;
import me.filoghost.holographicdisplays.core.CorePreconditions;
import me.filoghost.holographicdisplays.core.api.current.APIHologram;
import me.filoghost.holographicdisplays.core.api.current.APIHologramLine;
import me.filoghost.holographicdisplays.core.api.current.SimpleHologramLineClickEvent;
import me.filoghost.holographicdisplays.core.api.current.SimpleHologramLinePickupEvent;
import me.filoghost.holographicdisplays.core.base.BaseItemHologramLine;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

class APIItemHologramLine
extends BaseItemHologramLine
implements ItemHologramLine,
APIHologramLine {
    private HologramLinePickupListener pickupListener;
    private HologramLineClickListener clickListener;

    APIItemHologramLine(APIHologram hologram, ItemStack itemStack) {
        super(hologram, itemStack);
    }

    @Nullable
    public HologramLinePickupListener getPickupListener() {
        CorePreconditions.checkMainThread();
        return this.pickupListener;
    }

    public void setPickupListener(@Nullable HologramLinePickupListener pickupListener) {
        CorePreconditions.checkMainThread();
        this.checkNotDeleted();
        this.pickupListener = pickupListener;
    }

    @Override
    public boolean hasPickupCallback() {
        return this.pickupListener != null;
    }

    @Override
    protected void invokeExternalPickupCallback(Player player) {
        if (this.pickupListener != null) {
            this.pickupListener.onPickup((HologramLinePickupEvent)new SimpleHologramLinePickupEvent(player));
        }
    }

    @Nullable
    public HologramLineClickListener getClickListener() {
        CorePreconditions.checkMainThread();
        return this.clickListener;
    }

    public void setClickListener(@Nullable HologramLineClickListener clickListener) {
        CorePreconditions.checkMainThread();
        this.checkNotDeleted();
        this.clickListener = clickListener;
        this.setChanged();
    }

    @Override
    public boolean hasClickCallback() {
        return this.clickListener != null;
    }

    @Override
    protected void invokeExternalClickCallback(Player player) {
        if (this.clickListener != null) {
            this.clickListener.onClick((HologramLineClickEvent)new SimpleHologramLineClickEvent(player));
        }
    }
}

