/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.placeholder;

import java.util.Objects;
import me.filoghost.fcommons.Strings;
import me.filoghost.fcommons.collection.CaseInsensitiveString;
import me.filoghost.holographicdisplays.core.placeholder.PlaceholderIdentifier;
import me.filoghost.holographicdisplays.core.placeholder.PluginName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderOccurrence {
    private final CaseInsensitiveString unparsedContent;
    private final PluginName pluginName;
    private final PlaceholderIdentifier identifier;
    private final String argument;
    private final int hashCode;

    private PlaceholderOccurrence(String unparsedContent, PluginName pluginName, PlaceholderIdentifier identifier, String argument) {
        this.unparsedContent = new CaseInsensitiveString(unparsedContent);
        this.pluginName = pluginName;
        this.identifier = identifier;
        this.argument = argument;
        this.hashCode = Objects.hash(pluginName, identifier, argument);
    }

    public CaseInsensitiveString getUnparsedContent() {
        return this.unparsedContent;
    }

    @Nullable
    public PluginName getPluginName() {
        return this.pluginName;
    }

    @NotNull
    public PlaceholderIdentifier getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public String getArgument() {
        return this.argument;
    }

    public static PlaceholderOccurrence parse(String placeholderContent) {
        String identifierString;
        String[] parts;
        PluginName pluginName = null;
        String argument = null;
        if (placeholderContent.contains(":")) {
            parts = Strings.splitAndTrim((String)placeholderContent, (String)":", (int)2);
            identifierString = parts[0];
            argument = parts[1];
        } else {
            identifierString = placeholderContent;
        }
        if (identifierString.contains("/")) {
            parts = Strings.splitAndTrim((String)identifierString, (String)"/", (int)2);
            pluginName = new PluginName(parts[0]);
            identifierString = parts[1];
        }
        PlaceholderIdentifier identifier = new PlaceholderIdentifier(identifierString);
        return new PlaceholderOccurrence(placeholderContent, pluginName, identifier, argument);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PlaceholderOccurrence)) {
            return false;
        }
        PlaceholderOccurrence other = (PlaceholderOccurrence)obj;
        return this.hashCode == other.hashCode && Objects.equals(this.pluginName, other.pluginName) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.argument, other.argument);
    }

    public final int hashCode() {
        return this.hashCode;
    }
}

