/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.listener;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.filoghost.holographicdisplays.core.tracking.ClickableLineTracker;
import me.filoghost.holographicdisplays.nms.common.EntityID;
import me.filoghost.holographicdisplays.nms.common.PacketListener;
import org.bukkit.entity.Player;

public class LineClickListener
implements PacketListener {
    private final ConcurrentMap<Integer, ClickableLineTracker<?>> lineTrackerByEntityID = new ConcurrentHashMap();
    private final Set<QueuedClickEvent> queuedClickEvents = Collections.newSetFromMap(new ConcurrentHashMap());

    public boolean onAsyncEntityInteract(Player player, int entityID) {
        ClickableLineTracker lineTracker = (ClickableLineTracker)this.lineTrackerByEntityID.get(entityID);
        if (lineTracker != null) {
            this.queuedClickEvents.add(new QueuedClickEvent(player, lineTracker));
            return true;
        }
        return false;
    }

    public void processQueuedClickEvents() {
        for (QueuedClickEvent event : this.queuedClickEvents) {
            event.lineTracker.onClientClick(event.player);
        }
        this.queuedClickEvents.clear();
    }

    public void addLineTracker(EntityID clickableEntityID, ClickableLineTracker<?> lineTracker) {
        this.lineTrackerByEntityID.put(clickableEntityID.getNumericID(), lineTracker);
    }

    public void removeLineTracker(EntityID clickableEntityID) {
        if (clickableEntityID.hasInitializedNumericID()) {
            this.lineTrackerByEntityID.remove(clickableEntityID.getNumericID());
        }
    }

    private static class QueuedClickEvent {
        private final Player player;
        private final ClickableLineTracker<?> lineTracker;

        QueuedClickEvent(Player player, ClickableLineTracker<?> lineTracker) {
            this.player = player;
            this.lineTracker = lineTracker;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            QueuedClickEvent other = (QueuedClickEvent)obj;
            return this.player.equals((Object)other.player) && this.lineTracker.equals(other.lineTracker);
        }

        public int hashCode() {
            int result = this.player.hashCode();
            result = 31 * result + this.lineTracker.hashCode();
            return result;
        }
    }
}

