/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.base;

import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HologramPosition {
    @NotNull
    private ImmutablePosition position;
    @Nullable
    private World world;
    private int chunkX;
    private int chunkZ;
    @NotNull
    private ChunkLoadState chunkLoadState;

    HologramPosition(@NotNull ImmutablePosition position) {
        this.position = position;
        this.world = Bukkit.getWorld((String)position.getWorldName());
        this.chunkX = this.getChunkCoordinate(position.getX());
        this.chunkZ = this.getChunkCoordinate(position.getZ());
        this.chunkLoadState = ChunkLoadState.UNKNOWN;
    }

    final void set(@NotNull ImmutablePosition position) {
        boolean worldChanged = !this.position.isInSameWorld(position);
        int chunkX = this.getChunkCoordinate(position.getX());
        int chunkZ = this.getChunkCoordinate(position.getZ());
        this.position = position;
        if (worldChanged || this.chunkX != chunkX || this.chunkZ != chunkZ) {
            if (worldChanged) {
                this.world = position.getWorldIfLoaded();
            }
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.chunkLoadState = ChunkLoadState.UNKNOWN;
        }
    }

    private int getChunkCoordinate(double positionCoordinate) {
        return Location.locToBlock((double)positionCoordinate) >> 4;
    }

    void onWorldLoad(World world) {
        if (this.position.isInWorld(world)) {
            this.world = world;
            this.chunkLoadState = ChunkLoadState.UNKNOWN;
        }
    }

    void onWorldUnload(World world) {
        if (this.position.isInWorld(world)) {
            this.world = null;
            this.chunkLoadState = ChunkLoadState.NOT_LOADED;
        }
    }

    void onChunkLoad(Chunk chunk) {
        if (this.isInChunk(chunk)) {
            this.chunkLoadState = ChunkLoadState.LOADED;
        }
    }

    void onChunkUnload(Chunk chunk) {
        if (this.isInChunk(chunk)) {
            this.chunkLoadState = ChunkLoadState.NOT_LOADED;
        }
    }

    private boolean isInChunk(Chunk chunk) {
        return this.world != null && this.world == chunk.getWorld() && this.chunkX == chunk.getX() && this.chunkZ == chunk.getZ();
    }

    boolean isChunkLoaded() {
        if (this.chunkLoadState == ChunkLoadState.UNKNOWN) {
            this.chunkLoadState = this.world != null && this.world.isChunkLoaded(this.chunkX, this.chunkZ) ? ChunkLoadState.LOADED : ChunkLoadState.NOT_LOADED;
        }
        return this.chunkLoadState == ChunkLoadState.LOADED;
    }

    @Nullable
    World getWorldIfLoaded() {
        return this.world;
    }

    @NotNull
    ImmutablePosition getPosition() {
        return this.position;
    }

    public String toString() {
        return this.position.toString();
    }

    private static enum ChunkLoadState {
        LOADED,
        NOT_LOADED,
        UNKNOWN;

    }
}

