/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.base;

import me.filoghost.fcommons.Preconditions;
import me.filoghost.fcommons.logging.Log;
import me.filoghost.holographicdisplays.core.CorePreconditions;
import me.filoghost.holographicdisplays.core.base.BaseClickableHologramLine;
import me.filoghost.holographicdisplays.core.base.BaseHologram;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class BaseItemHologramLine
extends BaseClickableHologramLine {
    private ItemStack itemStack;

    public BaseItemHologramLine(BaseHologram hologram, ItemStack itemStack) {
        super(hologram);
        this.setItemStack(itemStack);
    }

    public void onPickup(Player player) {
        try {
            this.invokeExternalPickupCallback(player);
        }
        catch (Throwable t) {
            Log.warning((String)("The plugin " + this.getCreatorPlugin().getName() + " generated an exception when the player " + player.getName() + " picked up an item from a hologram."), (Throwable)t);
        }
    }

    public abstract boolean hasPickupCallback();

    protected abstract void invokeExternalPickupCallback(Player var1);

    @Nullable
    public ItemStack getItemStack() {
        return this.clone(this.itemStack);
    }

    public void setItemStack(@Nullable ItemStack itemStack) {
        CorePreconditions.checkMainThread();
        this.checkNotDeleted();
        if (itemStack != null) {
            Preconditions.checkArgument((0 < itemStack.getAmount() && itemStack.getAmount() <= 64 ? 1 : 0) != 0, (String)"itemStack.getAmount() must be between 1 and 64");
        }
        this.itemStack = this.clone(itemStack);
        this.setChanged();
    }

    private ItemStack clone(@Nullable ItemStack itemStack) {
        return itemStack != null ? itemStack.clone() : null;
    }

    @Override
    public double getHeight() {
        return 0.7;
    }

    public String toString() {
        return "ItemLine{itemStack=" + this.itemStack + "}";
    }
}

