/*
 * Decompiled with CFR 0.152.
 */
package me.filoghost.holographicdisplays.core.api.current;

import me.filoghost.fcommons.Preconditions;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.Position;
import me.filoghost.holographicdisplays.api.internal.HolographicDisplaysAPIProvider;
import me.filoghost.holographicdisplays.core.api.current.APIHologramManager;
import me.filoghost.holographicdisplays.core.api.current.DefaultHolographicDisplaysAPI;
import me.filoghost.holographicdisplays.core.base.ImmutablePosition;
import me.filoghost.holographicdisplays.core.placeholder.registry.PlaceholderRegistry;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class DefaultHolographicDisplaysAPIProvider
extends HolographicDisplaysAPIProvider {
    private final APIHologramManager apiHologramManager;
    private final PlaceholderRegistry placeholderRegistry;

    public DefaultHolographicDisplaysAPIProvider(APIHologramManager apiHologramManager, PlaceholderRegistry placeholderRegistry) {
        this.apiHologramManager = apiHologramManager;
        this.placeholderRegistry = placeholderRegistry;
    }

    public HolographicDisplaysAPI getHolographicDisplaysAPI(Plugin plugin) {
        Preconditions.notNull((Object)plugin, (String)"plugin");
        return new DefaultHolographicDisplaysAPI(plugin, this.apiHologramManager, this.placeholderRegistry);
    }

    public Position createPosition(World world, double x, double y, double z) {
        Preconditions.notNull((Object)world, (String)"world");
        return this.createPosition(world.getName(), x, y, z);
    }

    public Position createPosition(String worldName, double x, double y, double z) {
        return new ImmutablePosition(worldName, x, y, z);
    }

    public Position getPosition(Location location) {
        return ImmutablePosition.of(location);
    }

    public Position getPosition(Entity entity) {
        Preconditions.notNull((Object)entity, (String)"entity");
        return this.getPosition(entity.getLocation());
    }

    public Position getPosition(Block block) {
        return this.createPosition(block.getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
    }
}

