/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.settings;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.config.GenesisConfigShop;
import studio.magemonkey.genesis.settings.SettingsProperty;

public class ShopProperty
extends SettingsProperty {
    private Map<GenesisShop, Object> shopSettings;

    public ShopProperty(ConfigurationSection config, String path, Class<?> type) {
        super(config, path, type);
    }

    @Override
    public void load(ConfigurationSection config) {
        super.load(config);
        if (ClassManager.manager.getShops() != null && ClassManager.manager.getShops().getShops() != null) {
            this.readShops(this.type);
        }
    }

    public void readShops(Class<?> type) {
        for (GenesisShop shop : ClassManager.manager.getShops().getShops().values()) {
            this.readShop(shop, type);
        }
    }

    @Override
    public void update(Object o) {
        if (o instanceof GenesisShop) {
            GenesisShop shop = (GenesisShop)o;
            this.readShop(shop, this.type);
        }
        super.update(o);
    }

    public void readShop(GenesisShop shop, Class<?> type) {
        GenesisConfigShop configShop;
        FileConfiguration config;
        if (shop instanceof GenesisConfigShop && (config = (configShop = (GenesisConfigShop)shop).getConfig()).contains(this.path)) {
            if (this.shopSettings == null) {
                this.shopSettings = new HashMap<GenesisShop, Object>();
            }
            this.shopSettings.put(shop, this.read((ConfigurationSection)config));
        }
    }

    @Override
    public boolean containsValue(Object input, Object value) {
        GenesisShop shop;
        if (input instanceof GenesisShop && this.containsValueShop(shop = (GenesisShop)input, value)) {
            return true;
        }
        return super.containsValue(input, value);
    }

    public boolean containsValueShop(GenesisShop shop, Object value) {
        if (this.shopSettings != null && this.shopSettings.containsKey(shop)) {
            return this.isIdentical(this.shopSettings.get(shop), value);
        }
        return false;
    }

    @Override
    public boolean containsValueAny(Object value) {
        if (this.shopSettings != null) {
            for (GenesisShop shop : this.shopSettings.keySet()) {
                if (!this.containsValueShop(shop, value)) continue;
                return true;
            }
        }
        return super.containsValueAny(value);
    }

    @Override
    public Object getObject(Object input) {
        if (input instanceof GenesisShop) {
            GenesisShop shop = (GenesisShop)input;
            if (this.shopSettings != null && this.shopSettings.containsKey(shop)) {
                return this.shopSettings.get(shop);
            }
        }
        return super.getObject(input);
    }
}

