/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.genesis.settings;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import studio.magemonkey.genesis.core.GenesisBuy;
import studio.magemonkey.genesis.core.GenesisShop;
import studio.magemonkey.genesis.managers.ClassManager;
import studio.magemonkey.genesis.managers.config.GenesisConfigShop;
import studio.magemonkey.genesis.settings.ShopProperty;

public class ShopItemProperty
extends ShopProperty {
    private Map<GenesisBuy, Object> shopItemSettings;

    public ShopItemProperty(ConfigurationSection config, String path, Class<?> type) {
        super(config, path, type);
    }

    @Override
    public void load(ConfigurationSection config) {
        super.load(config);
        if (ClassManager.manager.getShops() != null && ClassManager.manager.getShops().getShops() != null) {
            this.readShopItems(this.type);
        }
    }

    public void readShopItems(Class<?> type) {
        for (GenesisShop shop : ClassManager.manager.getShops().getShops().values()) {
            if (!(shop instanceof GenesisConfigShop)) continue;
            GenesisConfigShop configShop = (GenesisConfigShop)shop;
            for (GenesisBuy buy : shop.getItems()) {
                this.readShopItem(buy, configShop, type);
            }
        }
    }

    @Override
    public void update(Object o) {
        if (o instanceof GenesisBuy) {
            GenesisBuy buy = (GenesisBuy)o;
            this.readShopItem(buy, this.type);
        }
        super.update(o);
    }

    public void readShopItem(GenesisBuy buy, Class<?> type) {
        if (buy.getShop() instanceof GenesisConfigShop) {
            GenesisConfigShop configShop = (GenesisConfigShop)buy.getShop();
            this.readShopItem(buy, configShop, type);
        }
    }

    public void readShopItem(GenesisBuy buy, GenesisConfigShop configShop, Class<?> type) {
        ConfigurationSection section = buy.getConfigurationSection(configShop);
        if (section != null && section.contains(this.path)) {
            if (this.shopItemSettings == null) {
                this.shopItemSettings = new HashMap<GenesisBuy, Object>();
            }
            this.shopItemSettings.put(buy, this.read(section));
        }
    }

    @Override
    public void readShop(GenesisShop shop, Class<?> type) {
        super.readShop(shop, type);
        for (GenesisBuy buy : shop.getItems()) {
            this.readShopItem(buy, type);
        }
    }

    @Override
    public boolean containsValue(Object input, Object value) {
        if (input instanceof GenesisBuy) {
            GenesisBuy buy = (GenesisBuy)input;
            if (this.containsValueShopItem(buy, value)) {
                return true;
            }
            return super.containsValue(buy.getShop(), value);
        }
        return super.containsValue(input, value);
    }

    public boolean containsValueShopItem(GenesisBuy buy, Object value) {
        if (this.shopItemSettings != null && this.shopItemSettings.containsKey(buy)) {
            return this.isIdentical(this.shopItemSettings.get(buy), value);
        }
        return false;
    }

    @Override
    public boolean containsValueAny(Object value) {
        if (this.shopItemSettings != null) {
            for (GenesisBuy buy : this.shopItemSettings.keySet()) {
                if (!this.containsValueShopItem(buy, value)) continue;
                return true;
            }
        }
        return super.containsValueAny(value);
    }

    @Override
    public Object getObject(Object input) {
        if (input instanceof GenesisBuy) {
            GenesisBuy buy = (GenesisBuy)input;
            if (this.shopItemSettings != null && this.shopItemSettings.containsKey(buy)) {
                return this.shopItemSettings.get(buy);
            }
            return super.getObject(buy.getShop());
        }
        return super.getObject(input);
    }
}

